package com.ruoyi.web.domain.planet;

import com.ruoyi.common.core.domain.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * @program: ThunderHubServer
 * @description: Planet entity class mapping to the database table
 * @author: Yumaoo
 * @create: 2025-06-08 17:19
 **/
@EqualsAndHashCode(callSuper = true)
@Setter
@Getter
@Data

public class Planet extends BaseEntity {
    private Integer planetId;
    private String name;
    private String filename;
    private String description;
    private Date createTime;

    @Override
    public String toString() {
        return "Planet{" +
                "planetId=" + planetId +
                ", name='" + name + '\'' +
                ", filename='" + filename + '\'' +
                ", description='" + description + '\'' +
                ", createTime=" + createTime +
                '}';
    }
}
