package com.ruoyi.web.domain.sys;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;


/**
 * 用户
 * @author Jrx
 */
@Data
@TableName("sys_user")
public class UserEntity implements Serializable {

    @TableId(value = "user_id", type = IdType.AUTO)
    private Long userId;
    private String userName;
    private String nickName;
    private String userType;
    private String email;
    private String phonenumber;

    // 数据库字段为sex，实体类使用gender更符合语义
    @TableField("sex")
    private String gender;

    private String avatar;
    private String password;

    // 状态字段映射
    @TableField("status")
    private Integer status;

    private String loginIp;

    // 日期类型统一使用LocalDateTime
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime loginDate;

    private String createBy;

    // 修正字段名与数据库一致
    @TableField("create_time")
    private LocalDateTime createTime;

    private String updateBy;

    // 修正字段名与数据库一致
    @TableField("update_time")
    private LocalDateTime updateTime;

    private String remark;
    private String fullName;

    // 使用Integer而非自定义枚举，与数据库字段类型一致
    private Integer state;

    private LocalDateTime added;
    private LocalDateTime lastLogin;
    private LocalDateTime lastAccess;
    private LocalDateTime lastHome;
    private LocalDateTime lastOffer;
    private LocalDateTime forumAccess;
    private LocalDateTime lastStaffmsg;
    private LocalDateTime lastPm;
    private LocalDateTime lastComment;
    private LocalDateTime lastPost;
    private LocalDateTime lastActive;

    private Integer privacy;
    private String regIp;
    private Integer level;
    private Long seedtime;
    private Long leechtime;

    @Schema(description = "真实上传量")
    private Long realUploaded;

    @Schema(description = "真实下载量")
    private Long realDownloaded;

    private String modcomment;
    private Long warningBy;
    private Integer warningTimes;
    private Boolean warning;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime warningUntil;

    private Long download;
    private Long upload;
    private Integer invitedBy;
    private Long bonus;
    private Long exp;
    private String checkCode;
    private Integer regType;

    // 状态辅助方法
    public boolean isUserLocked() {
        return this.state != null && this.state == 1;
    }

    public boolean isUserOK() {
        return this.state != null && this.state == 0;
    }
}
