package com.ruoyi.web.mapper.planet;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ruoyi.common.core.page.PageDomain;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.web.domain.planet.Planet;
import com.ruoyi.web.domain.planet.UserPlanet;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
@Mapper
public interface PlanetMapper extends BaseMapper<Planet> {
    List<Planet> selectPlanetList(@Param("offset") Long offset, @Param("pageSize") Long pageSize);
    Planet selectPlanetById(Long id);
    void insertPlanet(Planet planet);
    void updatePlanet(Planet planet);
    void updateUserPlanet(UserPlanet user);
    void deletePlanetsByIds(List<Long> ids);
    UserPlanet selectUserPlanetByUserId(Long userId);

    List<UserPlanet> selectUserPlanetList();
}
