/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    @Nullable
    private final T value;

    public Optional(@NotNull T value) {
        this.value = value;
    }

    private Optional() {
        this.value = null;
    }

    @NotNull
    public static <T> Optional<T> of(@Nullable T value) {
        return value == null ? EMPTY : new Optional<T>(value);
    }

    @NotNull
    public T get() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    @NotNull
    public T orElse(@NotNull T defaultValue) {
        return this.value != null ? this.value : defaultValue;
    }
}

