/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.common;

import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.TorrentUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;

public class Peer {
    private static final Logger logger = TorrentLoggerFactory.getLogger(Peer.class);
    private final InetSocketAddress address;
    private final String hostId;
    private ByteBuffer peerId;
    private volatile String hexPeerId;
    private volatile String hexInfoHash;

    public Peer(InetSocketAddress address) {
        this(address, null);
    }

    public Peer(String ip, int port) {
        this(new InetSocketAddress(ip, port), null);
    }

    public Peer(String ip, int port, ByteBuffer peerId) {
        this(new InetSocketAddress(ip, port), peerId);
    }

    public Peer(InetSocketAddress address, ByteBuffer peerId) {
        this.address = address;
        this.hostId = String.format("%s:%d", this.address.getAddress(), this.address.getPort());
        this.setPeerId(peerId);
    }

    public boolean hasPeerId() {
        return this.peerId != null;
    }

    public ByteBuffer getPeerId() {
        return this.peerId;
    }

    public byte[] getPeerIdArray() {
        return this.peerId == null ? null : this.peerId.array();
    }

    public void setPeerId(ByteBuffer peerId) {
        if (peerId != null) {
            this.peerId = peerId;
            this.hexPeerId = TorrentUtils.byteArrayToHexString(peerId.array());
        } else {
            this.peerId = null;
            this.hexPeerId = null;
        }
    }

    public String getStringPeerId() {
        try {
            return new String(this.peerId.array(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            LoggerUtils.warnAndDebugDetails(logger, "can not get peer id as string", e);
            return null;
        }
    }

    public String getHexPeerId() {
        return this.hexPeerId;
    }

    public String getShortHexPeerId() {
        return String.format("..%s", this.hexPeerId.substring(this.hexPeerId.length() - 6).toUpperCase());
    }

    public String getIp() {
        return this.address.getAddress().getHostAddress();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getHostIdentifier() {
        return this.hostId;
    }

    public byte[] getRawIp() {
        InetAddress address = this.address.getAddress();
        if (address == null) {
            return null;
        }
        return address.getAddress();
    }

    public boolean looksLike(Peer other) {
        if (other == null) {
            return false;
        }
        return this.hostId.equals(other.hostId) && this.getPort() == other.getPort();
    }

    public void setTorrentHash(String hexInfoHash) {
        this.hexInfoHash = hexInfoHash;
    }

    public String getHexInfoHash() {
        return this.hexInfoHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        if (this.hexPeerId == null && peer.hexPeerId == null) {
            return super.equals(o);
        }
        if (this.hexPeerId != null ? !this.hexPeerId.equals(peer.hexPeerId) : peer.hexPeerId != null) {
            return false;
        }
        return this.hexInfoHash != null ? this.hexInfoHash.equals(peer.hexInfoHash) : peer.hexInfoHash == null;
    }

    public int hashCode() {
        if (this.hexPeerId == null) {
            return super.hashCode();
        }
        int result = this.hexPeerId != null ? this.hexPeerId.hashCode() : 0;
        result = 31 * result + (this.hexInfoHash != null ? this.hexInfoHash.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Peer " + this.address + " for torrent " + this.hexInfoHash;
    }
}

