/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.Context;
import com.turn.ttorrent.client.announce.AnnounceException;
import com.turn.ttorrent.client.announce.AnnounceResponseListener;
import com.turn.ttorrent.client.announce.TrackerClient;
import com.turn.ttorrent.client.announce.TrackerClientFactory;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import java.net.ConnectException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;

public class Announce
implements Runnable {
    protected static final Logger logger = TorrentLoggerFactory.getLogger(Announce.class);
    private List<Peer> myPeers;
    private final TrackerClientFactory myTrackerClientFactory;
    private final ConcurrentMap<String, TrackerClient> clients = new ConcurrentHashMap<String, TrackerClient>();
    private final Context myContext;
    private Thread thread = null;
    private volatile boolean stop;
    private boolean forceStop;
    private int myAnnounceInterval;
    private TrackerClient myDefaultTracker;

    public Announce(Context context, TrackerClientFactory trackerClientFactory) {
        this.myTrackerClientFactory = trackerClientFactory;
        this.myContext = context;
        this.myPeers = new CopyOnWriteArrayList<Peer>();
    }

    public void forceAnnounce(AnnounceableInformation torrent, AnnounceResponseListener listener, AnnounceRequestMessage.RequestEvent event) throws UnknownServiceException, UnknownHostException {
        URI trackerUrl = URI.create(torrent.getAnnounce());
        TrackerClient client = (TrackerClient)this.clients.get(trackerUrl.toString());
        try {
            if (client == null) {
                client = this.myTrackerClientFactory.createTrackerClient(this.myPeers, trackerUrl);
                client.register(listener);
                this.clients.put(trackerUrl.toString(), client);
            }
            client.announceAllInterfaces(event, false, torrent);
        }
        catch (AnnounceException e) {
            logger.info(String.format("Unable to force announce torrent %s on tracker %s.", torrent.getHexInfoHash(), String.valueOf(trackerUrl)));
            logger.debug(String.format("Unable to force announce torrent %s on tracker %s.", torrent.getHexInfoHash(), String.valueOf(trackerUrl)), e);
        }
    }

    public void start(URI defaultTrackerURI, AnnounceResponseListener listener, Peer[] peers, int announceInterval) {
        this.myAnnounceInterval = announceInterval;
        this.myPeers.addAll(Arrays.asList(peers));
        if (defaultTrackerURI != null) {
            try {
                this.myDefaultTracker = this.myTrackerClientFactory.createTrackerClient(this.myPeers, defaultTrackerURI);
                this.myDefaultTracker.register(listener);
                this.clients.put(defaultTrackerURI.toString(), this.myDefaultTracker);
            }
            catch (Exception exception) {}
        } else {
            this.myDefaultTracker = null;
        }
        this.stop = false;
        this.forceStop = false;
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread(this);
            this.thread.setName("torrent tracker announce thread");
            this.thread.start();
        }
    }

    public void setAnnounceInterval(int announceInterval) {
        if (announceInterval <= 0) {
            this.stop(true);
            return;
        }
        if (this.myAnnounceInterval == announceInterval) {
            return;
        }
        logger.trace("Setting announce interval to {}s per tracker request.", announceInterval);
        this.myAnnounceInterval = announceInterval;
    }

    public void stop() {
        this.stop = true;
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            for (TrackerClient client : this.clients.values()) {
                client.close();
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.myPeers.clear();
        this.thread = null;
    }

    @Override
    public void run() {
        logger.info("Starting announce loop...");
        while (!this.stop && !Thread.currentThread().isInterrupted()) {
            List<AnnounceableInformation> announceableInformationList = this.myContext.getTorrentsStorage().announceableTorrents();
            logger.debug("Starting announce for {} torrents", announceableInformationList.size());
            this.announceAllTorrents(announceableInformationList, AnnounceRequestMessage.RequestEvent.NONE);
            try {
                Thread.sleep(this.myAnnounceInterval * 1000);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        this.announceAllTorrents(this.myContext.getTorrentsStorage().announceableTorrents(), AnnounceRequestMessage.RequestEvent.STOPPED);
        logger.info("Exited announce loop.");
    }

    private void defaultAnnounce(List<AnnounceableInformation> torrentsForAnnounce) {
        for (AnnounceableInformation torrent : torrentsForAnnounce) {
            if (this.stop || Thread.currentThread().isInterrupted()) break;
            try {
                TrackerClient trackerClient = this.getCurrentTrackerClient(torrent);
                if (trackerClient != null) {
                    trackerClient.announceAllInterfaces(AnnounceRequestMessage.RequestEvent.NONE, false, torrent);
                    continue;
                }
                logger.warn("Tracker client for {} is null. Torrent is not announced on tracker", (Object)torrent.getHexInfoHash());
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                logger.debug(e.getMessage(), e);
            }
        }
    }

    private void announceAllTorrents(List<AnnounceableInformation> announceableInformationList, AnnounceRequestMessage.RequestEvent event) {
        logger.debug("Started multi announce. Event {}, torrents {}", (Object)event, announceableInformationList);
        HashMap<String, ArrayList<AnnounceableInformation>> torrentsGroupingByAnnounceUrl = new HashMap<String, ArrayList<AnnounceableInformation>>();
        for (AnnounceableInformation torrent : announceableInformationList) {
            URI uriForTorrent = this.getURIForTorrent(torrent);
            if (uriForTorrent == null) continue;
            String torrentURI = uriForTorrent.toString();
            ArrayList<AnnounceableInformation> sharedTorrents = (ArrayList<AnnounceableInformation>)torrentsGroupingByAnnounceUrl.get(torrentURI);
            if (sharedTorrents == null) {
                sharedTorrents = new ArrayList<AnnounceableInformation>();
                torrentsGroupingByAnnounceUrl.put(torrentURI, sharedTorrents);
            }
            sharedTorrents.add(torrent);
        }
        ArrayList<AnnounceableInformation> unannouncedTorrents = new ArrayList<AnnounceableInformation>();
        for (Map.Entry e : torrentsGroupingByAnnounceUrl.entrySet()) {
            TrackerClient trackerClient = (TrackerClient)this.clients.get(e.getKey());
            if (trackerClient != null) {
                try {
                    trackerClient.multiAnnounce(event, false, (List)e.getValue(), this.myPeers);
                }
                catch (AnnounceException t) {
                    LoggerUtils.warnAndDebugDetails(logger, "problem in multi announce {}", t.getMessage(), t);
                    unannouncedTorrents.addAll((Collection)e.getValue());
                }
                catch (ConnectException t) {
                    LoggerUtils.warnWithMessageAndDebugDetails(logger, "Cannot connect to the tracker {}", e.getKey(), t);
                    logger.debug("next torrents contain {} in tracker list. {}", e.getKey(), e.getValue());
                }
                continue;
            }
            logger.warn("Tracker client for {} is null. Torrents are not announced on tracker", e.getKey());
            if (e.getKey() != null && !((String)e.getKey()).isEmpty()) continue;
            for (AnnounceableInformation announceableInformation : (List)e.getValue()) {
                this.myContext.getTorrentsStorage().remove(announceableInformation.getHexInfoHash());
            }
        }
        if (unannouncedTorrents.size() > 0) {
            this.defaultAnnounce(unannouncedTorrents);
        }
    }

    public TrackerClient getCurrentTrackerClient(AnnounceableInformation torrent) {
        URI uri = this.getURIForTorrent(torrent);
        if (uri == null) {
            return null;
        }
        return (TrackerClient)this.clients.get(uri.toString());
    }

    private URI getURIForTorrent(AnnounceableInformation torrent) {
        List<List<String>> announceList = torrent.getAnnounceList();
        if (announceList.size() == 0) {
            return null;
        }
        List<String> uris = announceList.get(0);
        if (uris.size() == 0) {
            return null;
        }
        return URI.create(uris.get(0));
    }

    public URI getDefaultTrackerURI() {
        if (this.myDefaultTracker == null) {
            return null;
        }
        return this.myDefaultTracker.getTrackerURI();
    }

    private void stop(boolean hard) {
        this.forceStop = hard;
        this.stop();
    }
}

