/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.tracker.MultiAnnounceRequestProcessor;
import com.turn.ttorrent.tracker.PeerCollectorThread;
import com.turn.ttorrent.tracker.TorrentsRepository;
import com.turn.ttorrent.tracker.TrackedTorrent;
import com.turn.ttorrent.tracker.TrackerRequestProcessor;
import com.turn.ttorrent.tracker.TrackerServiceContainer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;

public class Tracker {
    private static final Logger logger = TorrentLoggerFactory.getLogger(Tracker.class);
    public static final String ANNOUNCE_URL = "/announce";
    public static final int DEFAULT_TRACKER_PORT = 6969;
    public static final String DEFAULT_VERSION_STRING = "BitTorrent Tracker (ttorrent)";
    private Connection connection;
    private final TorrentsRepository myTorrentsRepository;
    private PeerCollectorThread myPeerCollectorThread;
    private boolean stop;
    private String myAnnounceUrl;
    private final int myPort;
    private SocketAddress myBoundAddress = null;
    private final TrackerServiceContainer myTrackerServiceContainer;

    public Tracker(int port) throws IOException {
        this(port, Tracker.getDefaultAnnounceUrl(new InetSocketAddress(InetAddress.getLocalHost(), port)).toString());
    }

    public Tracker(int port, String announceURL) throws IOException {
        this.myPort = port;
        this.myAnnounceUrl = announceURL;
        this.myTorrentsRepository = new TorrentsRepository(10);
        TrackerRequestProcessor requestProcessor = new TrackerRequestProcessor(this.myTorrentsRepository);
        this.myTrackerServiceContainer = new TrackerServiceContainer(requestProcessor, new MultiAnnounceRequestProcessor(requestProcessor));
        this.myPeerCollectorThread = new PeerCollectorThread(this.myTorrentsRepository);
    }

    public Tracker(int port, String announceURL, TrackerRequestProcessor requestProcessor, TorrentsRepository torrentsRepository) throws IOException {
        this.myPort = port;
        this.myAnnounceUrl = announceURL;
        this.myTorrentsRepository = torrentsRepository;
        this.myTrackerServiceContainer = new TrackerServiceContainer(requestProcessor, new MultiAnnounceRequestProcessor(requestProcessor));
        this.myPeerCollectorThread = new PeerCollectorThread(this.myTorrentsRepository);
    }

    private static URL getDefaultAnnounceUrl(InetSocketAddress address) {
        try {
            return new URL("http", address.getAddress().getCanonicalHostName(), address.getPort(), ANNOUNCE_URL);
        }
        catch (MalformedURLException mue) {
            logger.error("Could not build tracker URL: {}!", mue, (Object)mue);
            return null;
        }
    }

    public String getAnnounceUrl() {
        return this.myAnnounceUrl;
    }

    public URI getAnnounceURI() {
        try {
            URL announceURL = new URL(this.getAnnounceUrl());
            if (announceURL != null) {
                return announceURL.toURI();
            }
        }
        catch (URISyntaxException e) {
            logger.error("Cannot convert announce URL to URI", e);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot create URL from announceURL", e);
        }
        return null;
    }

    public void start(boolean startPeerCleaningThread) throws IOException {
        logger.info("Starting BitTorrent tracker on {}...", (Object)this.getAnnounceUrl());
        this.connection = new SocketConnection(new ContainerServer(this.myTrackerServiceContainer));
        ArrayList<SocketAddress> tries = new ArrayList<SocketAddress>(){
            {
                try {
                    this.add(new InetSocketAddress(InetAddress.getByAddress(new byte[4]), Tracker.this.myPort));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.add(new InetSocketAddress(InetAddress.getLocalHost(), Tracker.this.myPort));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.add(new InetSocketAddress(InetAddress.getByName(new URL(Tracker.this.getAnnounceUrl()).getHost()), Tracker.this.myPort));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        boolean started = false;
        for (SocketAddress address : tries) {
            try {
                this.myBoundAddress = this.connection.connect(address);
                if (this.myBoundAddress == null) continue;
                logger.info("Started torrent tracker on {}", address);
                started = true;
                break;
            }
            catch (IOException ioe) {
                logger.info("Can't start the tracker using address{} : ", (Object)address.toString(), (Object)ioe.getMessage());
            }
        }
        if (!started) {
            logger.error("Cannot start tracker on port {}. Stopping now...", this.myPort);
            this.stop();
            return;
        }
        if (startPeerCleaningThread) {
            if (this.myPeerCollectorThread == null || !this.myPeerCollectorThread.isAlive() || this.myPeerCollectorThread.getState() != Thread.State.NEW) {
                this.myPeerCollectorThread = new PeerCollectorThread(this.myTorrentsRepository);
            }
            this.myPeerCollectorThread.setName("peer-peerCollectorThread:" + this.myPort);
            this.myPeerCollectorThread.start();
        }
    }

    public void stop() {
        this.stop = true;
        try {
            this.connection.close();
            logger.info("BitTorrent tracker closed.");
        }
        catch (IOException ioe) {
            logger.error("Could not stop the tracker: {}!", (Object)ioe.getMessage());
        }
        if (this.myPeerCollectorThread != null && this.myPeerCollectorThread.isAlive()) {
            this.myPeerCollectorThread.interrupt();
            try {
                this.myPeerCollectorThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            logger.info("Peer collection terminated.");
        }
    }

    public synchronized TrackedTorrent announce(TrackedTorrent torrent) {
        TrackedTorrent existing = this.myTorrentsRepository.getTorrent(torrent.getHexInfoHash());
        if (existing != null) {
            logger.warn("Tracker already announced torrent with hash {}.", (Object)existing.getHexInfoHash());
            return existing;
        }
        this.myTorrentsRepository.putIfAbsent(torrent.getHexInfoHash(), torrent);
        logger.info("Registered new torrent with hash {}.", (Object)torrent.getHexInfoHash());
        return torrent;
    }

    public void setAcceptForeignTorrents(boolean acceptForeignTorrents) {
        this.myTrackerServiceContainer.setAcceptForeignTorrents(acceptForeignTorrents);
    }

    public Collection<TrackedTorrent> getTrackedTorrents() {
        return Collections.unmodifiableCollection(this.myTorrentsRepository.getTorrents().values());
    }

    public TrackedTorrent getTrackedTorrent(String hash) {
        return this.myTorrentsRepository.getTorrent(hash);
    }

    public void setAnnounceInterval(int announceInterval) {
        this.myTrackerServiceContainer.setAnnounceInterval(announceInterval);
    }

    public void setPeerCollectorExpireTimeout(int expireTimeout) {
        this.myPeerCollectorThread.setTorrentExpireTimeoutSec(expireTimeout);
    }
}

