﻿/**
 * @name umi 的路由配置
 * @description 只支持 path,component,routes,redirect,wrappers,name,icon 的配置
 * @param path  path 只支持两种占位符配置，第一种是动态参数 :id 的形式，第二种是 * 通配符，通配符只能出现路由字符串的最后。
 * @param component 配置 location 和 path 匹配后用于渲染的 React 组件路径。可以是绝对路径，也可以是相对路径，如果是相对路径，会从 src/pages 开始找起。
 * @param routes 配置子路由，通常在需要为多个路径增加 layout 组件时使用。
 * @param redirect 配置路由跳转
 * @param wrappers 配置路由组件的包装组件，通过包装组件可以为当前的路由组件组合进更多的功能。 比如，可以用于路由级别的权限校验
 * @param name 配置路由的标题，默认读取国际化文件 menu.ts 中 menu.xxxx 的值，如配置 name 为 login，则读取 menu.ts 中 menu.login 的取值作为标题
 * @param icon 配置路由的图标，取值参考 https://ant.design/components/icon-cn， 注意去除风格后缀和大小写，如想要配置图标为 <StepBackwardOutlined /> 则取值应为 stepBackward 或 StepBackward，如想要配置图标为 <UserOutlined /> 则取值应为 user 或者 User
 * @doc https://umijs.org/docs/guides/routes
 */
export default [
  {
    path: '/',
    redirect: '/account/center',
  },
  {
    path: '*',
    layout: false,
    component: './404',
  },
  {
    path: '/user',
    layout: false,
    routes: [
      {
        name: 'login',
        path: '/user/login',
        component: './User/Login',
      },
    ],
  },
  {
    path: '/account',
    routes: [
      {
        name: 'acenter',
        path: '/account/center',
        component: './User/Center',
      },
      {
        name: 'asettings',
        path: '/account/settings',
        component: './User/Settings',
      },
    ],
  },
  {
    name: 'system',
    path: '/system',
    routes: [
      {
        name: '字典数据',
        path: '/system/dict-data/index/:id',
        component: './System/DictData',
      },
      {
        name: '分配用户',
        path: '/system/role-auth/user/:id',
        component: './System/Role/authUser',
      },
    ]
  },
  {
    name: 'monitor',
    path: '/monitor',
    routes: [
      {
        name: '任务日志',
        path: '/monitor/job-log/index/:id',
        component: './Monitor/JobLog',
      },
    ]
  },
  {
    name: 'tool',
    path: '/tool',
    routes: [
      {
        name: '导入表',
        path: '/tool/gen/import',
        component: './Tool/Gen/import',
      },
      {
        name: '编辑表',
        path: '/tool/gen/edit',
        component: './Tool/Gen/edit',
      },
    ]
  },
  {
    path: '/bounty',
    name: '悬赏管理',
    icon: 'read',
    routes: [
      {
        path: '/bounty/list',
        component: '@/pages/Bounty/List',
      },
      {
        path: '/bounty/detail/:id',
        component: '@/pages/Bounty/Detail',
      },
      {
        name: 'bountyPublish',  // 发布悬赏页面名称
        path: '/bounty/publish',  // 访问路径
        component: './Bounty/BountyPublish'  // 对应页面文件路径（相对于 src/pages）
      },
      {
        name: 'bountyReply',  // 回复悬赏页面名称
        path: '/bounty/reply',  // 访问路径
        component: './Bounty/BountyReply'  // 对应页面文件路径
      }

    ],
  },


  {
    name: '帖子中心',
    icon: 'read',
    path: '/post/center',
    component: './PostCenter/index.tsx',
  },
  {
    name: '帖子详情',
    path: '/post-detail/:id',
    component: './PostCenter/PostDetail.tsx',
    hideInMenu: true,
  },
  {
    name: '个人中心',
    path: '/user-center',
    component: './UserCenter/index.tsx',
    hideInMenu: true,
  },
  {
    name: '帖子审核',
    path: '/post-review',
    component: './PostReview/index.tsx',
    hideInMenu: true,
  },
  {
    name: '种子列表',
    path: '/torrent-list',
    component: './Torrent/torrentList.tsx',
    hideInMenu: true,
  },
  {
    name: '种子详情界面',
    path: '/torrent-detail/:id',
    component: './Torrent/torrentDetail.tsx',
    hideInMenu: true,
  },
  {
    name: '上传种子界面',
    path: '/torrent-upload',
    component: './Torrent/torrentUpload.tsx',
    hideInMenu: true,
  },
    {
    name: '审核种子界面',
    path: '/torrent-audit-list',
    component: './Torrent/torrentAuditList.tsx',
    hideInMenu: true,
  },
{
    name: '审核种子详情界面',
    path: '/torrent-audit',
    component: './Torrent/torrentAudit.tsx',
    hideInMenu: true,
  },
];
