import React, { useState } from 'react';

const planets = [
    { name: 'Mercury', desc: 'The smallest planet.', img: 'https://images.unsplash.com/photo-1462331940025-496dfbfc7564?auto=format&fit=crop&w=400&q=80' },
    { name: 'Venus', desc: 'The hottest planet.', img: 'https://images.unsplash.com/photo-1465101046530-73398c7f28ca?auto=format&fit=crop&w=400&q=80' },
    { name: 'Earth', desc: 'Our home planet.', img: 'https://images.unsplash.com/photo-1465101178521-c1a9136a3b99?auto=format&fit=crop&w=400&q=80' },
    { name: 'Mars', desc: 'The red planet.', img: 'https://images.unsplash.com/photo-1462331940025-496dfbfc7564?auto=format&fit=crop&w=400&q=80' },
    { name: 'Jupiter', desc: 'The largest planet.', img: 'https://images.unsplash.com/photo-1465101178521-c1a9136a3b99?auto=format&fit=crop&w=400&q=80' },
];

const navItems = ['首页', '资源', '关于', '联系'];

const Home: React.FC = () => {
    const [search, setSearch] = useState('');

    const filteredPlanets = planets.filter(p =>
        p.name.toLowerCase().includes(search.toLowerCase())
    );

    return (
        <div style={{ fontFamily: 'sans-serif', background: 'linear-gradient(to bottom, #0f2027, #2c5364)', minHeight: '100vh', color: '#fff' }}>
            {/* 导航栏 */}
            <nav style={{ display: 'flex', justifyContent: 'space-between', alignItems: 'center', padding: '24px 48px', background: 'rgba(0,0,0,0.4)' }}>
                <div style={{ fontWeight: 'bold', fontSize: 28, letterSpacing: 2 }}>🌌 PT星球</div>
                <div>
                    {navItems.map(item => (
                        <a
                            key={item}
                            href="#"
                            style={{
                                color: '#fff',
                                margin: '0 18px',
                                textDecoration: 'none',
                                fontSize: 18,
                                transition: 'color 0.2s',
                            }}
                        >
                            {item}
                        </a>
                    ))}
                </div>
            </nav>

            {/* 搜索框 */}
            <div style={{ display: 'flex', justifyContent: 'center', margin: '48px 0 32px 0' }}>
                <input
                    type="text"
                    placeholder="搜索星球资源..."
                    value={search}
                    onChange={e => setSearch(e.target.value)}
                    style={{
                        width: 360,
                        padding: '12px 20px',
                        borderRadius: 24,
                        border: 'none',
                        fontSize: 18,
                        outline: 'none',
                        boxShadow: '0 2px 12px rgba(0,0,0,0.2)',
                    }}
                />
            </div>

            {/* 资源卡片 */}
            <div style={{
                display: 'flex',
                flexWrap: 'wrap',
                justifyContent: 'center',
                gap: '32px',
                padding: '0 48px 48px 48px'
            }}>
                {filteredPlanets.map(planet => (
                    <div
                        key={planet.name}
                        style={{
                            background: 'rgba(255,255,255,0.08)',
                            borderRadius: 18,
                            width: 260,
                            boxShadow: '0 4px 24px rgba(0,0,0,0.18)',
                            overflow: 'hidden',
                            transition: 'transform 0.2s',
                        }}
                    >
                        <img src={planet.img} alt={planet.name} style={{ width: '100%', height: 140, objectFit: 'cover' }} />
                        <div style={{ padding: 20 }}>
                            <div style={{ fontWeight: 'bold', fontSize: 22, marginBottom: 8 }}>{planet.name}</div>
                            <div style={{ fontSize: 16, color: '#cfd8dc' }}>{planet.desc}</div>
                        </div>
                    </div>
                ))}
            </div>
        </div>
    );
};

export default Home;