import { request } from '@umijs/max';

// 获取分类
export async function getCategories() {
    return request('/api/tag/all_cat');
}

// 获取种子列表
export async function getTorrentList(params: {
    category?: string;
    sortField: string;
    sortDirection: string;
    pageNum: number;
    pageSize: number;
}) {
    return request('/api/torrent/torrentList', {
        method: 'POST',
        data: params,
    });
}

export async function getTorrentInfo(params: {
    id: string | number;
}) {
    return request(`/api/torrent/info/${params.id}`, {
        method: 'POST',
    });
}


export async function downloadTorrent(params: {
    id: string | number;
    passkey?: string;
}) {
    return request('/api/torrent/download', {
        method: 'GET',
        params: {
            id: params.id,
        },
        responseType: 'blob',
    });
}

export async function addComment(params: {
    torrentId: number;
    pid?: number;
    comment: string;
}) {
    return request('/api/torrent/addComment', {
        method: 'POST',
        data: params,
    });
}

export async function getComments(params: {
    torrentId: number;
    pageNum?: number;
    pageSize?: number;
}) {
    return request('/api/torrent/comments', {
        method: 'GET',
        params,
    });
}

export interface TorrentAddParam {
    name: string;
    title: string;
    subheading: string;
    cover?: string;
    description: string;
    category: number;
    status?: number;
    anonymous?: number;
    remark?: string;
}

// 审核种子参数
export interface TorrentAuditParam {
    id: number;
    status: number;
    remark?: string;
}

// 种子实体
export interface TorrentEntity {
    id?: number;
    infoHash?: Uint8Array;
    name?: string;
    filename?: string;
    title?: string;
    subheading?: string;
    cover?: string;
    description?: string;
    category?: number;
    status?: number;
    fileStatus?: number;
    reviewer?: number;
    createTime?: string;
    updateTime?: string;
    owner?: number;
    size?: number;
    type?: number;
    fileCount?: number;
    comments?: number;
    views?: number;
    hits?: number;
    visible?: number;
    anonymous?: number;
    leechers?: number;
    seeders?: number;
    completions?: number;
    remark?: string;
}

// 添加种子
export async function addTorrent(param: TorrentAddParam) {
    return request('/api/torrent/add', {
        method: 'POST',
        data: param,
    });
}

// 审核种子
export async function auditTorrent(param: TorrentAuditParam) {
    return request('/api/torrent/audit', {
        method: 'POST',
        data: param,
    });
}

// 点赞
export async function favoriteTorrent(id: number) {
    return request('/api/torrent/favorite', {
        method: 'POST',
        params: { id },
    });
}

// 上传种子.torrent
export async function uploadTorrentFile(file: File, id: number) {
    const formData = new FormData();
    formData.append('file', file);
    formData.append('id', id.toString());
    return request('/api/torrent/upload', {
        method: 'POST',
        data: formData,
        requestType: 'form',
        responseType: 'blob',
    });
}

// 更新种子
export async function updateTorrent(entity: TorrentEntity) {
    return request('/api/torrent/update', {
        method: 'POST',
        data: entity,
    });
}

// 删除种子
export async function deleteTorrent(ids: number[]) {
    return request('/api/torrent/delete', {
        method: 'POST',
        data: ids,
    });
}

// 获取服务器Tracker
export async function getTracker() {
    return request('/api/torrent/tracker', {
        method: 'POST',
    });
}