# 单元测试文档

## 概述

本项目包含完整的前端和后端单元测试，确保代码质量和功能正确性。

## 前端测试

### 测试框架
- Jest: 测试运行器和断言库
- @testing-library/react: React组件测试工具
- @testing-library/jest-dom: DOM断言扩展

### 测试覆盖范围

#### 服务层测试 (services/)
- **post.test.ts**: 帖子相关API接口测试
  - 帖子列表获取
  - 帖子详情获取
  - 评论功能
  - 收藏和点赞
  - 帖子发布和管理
  - 文件上传
  - 审核功能
  - 举报功能
  - 错误处理

### 运行测试

```bash
# 运行所有测试
npm run test

# 监听模式运行测试
npm run test:watch

# 生成覆盖率报告
npm run test:coverage

# CI环境运行测试
npm run test:ci
```

### 测试配置

测试配置文件：
- `jest.config.ts`: Jest主配置
- `tests/setup.ts`: 测试环境设置

## 后端测试

### 测试框架
- JUnit 5: 测试框架
- Mockito: Mock框架
- Spring Boot Test: Spring测试支持

### 测试覆盖范围

#### 控制器测试
- **PostCenterControllerTest**: 帖子中心控制器测试
  - 帖子列表API
  - 帖子详情API
  - 评论API
  - 收藏和点赞API
  - 帖子发布API
  - 文件上传API
  - 帖子管理API
  - 举报API

#### 服务层测试
- **PostServiceTest**: 帖子服务测试
- **PostCommentServiceTest**: 评论服务测试
- **PostTagServiceTest**: 标签服务测试

### 运行测试

```bash
# Maven运行测试
mvn test

# 生成测试报告
mvn surefire-report:report

# 运行特定测试类
mvn test -Dtest=PostCenterControllerTest
```

## 测试最佳实践

### 1. 测试命名规范
- 测试方法名应清晰描述测试场景
- 使用中文描述测试目的
- 格式：`test[功能名]_[场景]`

### 2. 测试结构
- **Arrange**: 准备测试数据
- **Act**: 执行被测试方法
- **Assert**: 验证结果

### 3. Mock使用
- 只Mock外部依赖
- 验证重要的方法调用
- 使用合理的测试数据

### 4. 覆盖率要求
- 行覆盖率: ≥80%
- 分支覆盖率: ≥80%
- 函数覆盖率: ≥80%

## CI/CD集成

### Jenkins配置
测试在以下情况自动运行：
1. 代码提交到Gerrit
2. 合并请求创建
3. 定期构建

### 测试报告
- 前端: 生成HTML覆盖率报告
- 后端: 生成Surefire测试报告
- 集成到Jenkins构建结果

## 故障排除

### 常见问题
1. **测试超时**: 增加超时时间或优化测试逻辑
2. **Mock失效**: 检查Mock配置和方法签名
3. **异步测试**: 使用适当的异步测试工具

### 调试技巧
1. 使用`console.log`输出调试信息
2. 运行单个测试文件进行调试
3. 检查测试数据和期望结果

## 维护指南

### 添加新测试
1. 为新功能编写对应测试
2. 确保测试覆盖正常和异常情况
3. 更新测试文档

### 更新现有测试
1. 功能变更时同步更新测试
2. 保持测试数据的有效性
3. 定期重构测试代码 