declare namespace API {
  namespace Post {
    interface PostInfo {
      postId: number;
      id?: number;
      title: string;
      content?: string;
      summary?: string;
      coverImage?: string;
      authorId?: number;
      author: string;
      views: number;
      comments: number;
      favorites: number;
      likes?: number;
      status: string;
      publishTime: string;
      tags: string;
      promotionPlanId?: number;
      createBy?: string;
      createTime?: string;
      updateBy?: string;
      updateTime?: string;
      remark?: string;
    }

    interface PostComment {
      commentId: number;
      postId: number;
      content: string;
      userId?: number;
      userName?: string;
      userAvatar?: string;
      parentId?: number;
      replyUserId?: number;
      replyUserName?: string;
      status: string;
      likes: number;
      createBy?: string;
      createTime?: string;
      updateBy?: string;
      updateTime?: string;
      remark?: string;
    }

    interface PostTag {
      tagId: number;
      tagName: string;
      tagColor?: string;
      postCount: number;
      status: string;
      createBy?: string;
      createTime?: string;
      updateBy?: string;
      updateTime?: string;
      remark?: string;
    }

    interface PostFavorite {
      favoriteId: number;
      postId: number;
      userId: number;
      postTitle?: string;
      postCover?: string;
      status: string;
      createBy?: string;
      createTime?: string;
      updateBy?: string;
      updateTime?: string;
      remark?: string;
    }

    interface PostLike {
      likeId: number;
      postId: number;
      userId: number;
      createTime?: string;
    }
  }

  // 通用响应类型
  interface AjaxResult<T = any> {
    code: number;
    msg?: string;
    data?: T;
  }

  interface TableDataInfo<T = any> {
    code: number;
    rows: T[];
    total: number;
    msg?: string;
  }

  interface PageParams {
    pageNum?: number;
    pageSize?: number;
  }
} 