import React, { useState, useEffect } from 'react';
import { Table, Button, message, Space } from 'antd';
import axios from 'axios'; // 新增 axios 导入

const BountyManage: React.FC = () => {
  const [dataSource, setDataSource] = useState<API.Bounty[]>([]);

  // 加载悬赏列表（修改请求方式）
  useEffect(() => {
    const loadBountyList = async () => {
      try {
        const res = await axios.get('/api/bounties', { params: { status: [0, 1, 2].join(',') } }); // 替换 get 为 axios.get
        if (res.data.code === 200) {
          setDataSource(res.data.data.records || []);
        }
      } catch (err) {
        message.error('加载悬赏列表失败');
      }
    };
    loadBountyList();
  }, []);

  // 操作列（修改请求方式）
  const handleClose = async (id: number) => {
    try {
      //这个接口哪来的？？
      const res = await axios.post('/api/bounties/close', { id }); // 替换 post 为 axios.post
      if (res.data.code === 200) {
        message.success('悬赏已关闭');
        setDataSource(dataSource.map(item => item.id === id ? { ...item, status: 2 } : item));
      }
    } catch (err) {
      message.error('关闭失败');
    }
  };

  const columns = [
    { title: '我是manage标题', dataIndex: 'title' },
    { title: '奖励', dataIndex: 'reward' },
    {
      title: '状态',
      dataIndex: 'status',
      // 显式声明 status 为 number 类型
      render: (status: number) => status === 0 ? '进行中' : status === 1 ? '已完成' : '已关闭'
    },
    {
      title: '操作',
      // 显式声明 record 为 API.Bounty 类型（需确保 API.Bounty 已在 types.d.ts 中定义）
      render: (value: unknown, record: API.Bounty) => (
        <Space>
          <Button type="link" onClick={() => handleClose(record.id)}>关闭</Button>
        </Space>
      )
    }
  ];

  return (
    <div className="page-container">
      <h2>悬赏管理</h2>
      <Table
        dataSource={dataSource}
        columns={columns}
        rowKey="id"
        pagination={{ pageSize: 10 }}
      />
    </div>
  );
};

export default BountyManage;
