export interface Post {
  postId?: number;
  id: string | number;
  title: string;
  author: string;
  publishTime: string;
  tags: string[];
  views: number;
  comments?: number;
  favorites?: number;
  likes?: number;
  coverImage?: string;
  summary?: string;
  content?: string;
  status?: string;
  authorId?: number;
  createTime?: string;
  updateTime?: string;
  promotionPlanId?: number;
  isPromoted?: boolean;
}

export interface CommentType {
  commentId?: number;
  id: number;
  author: string;
  avatar: string;
  content: string;
  datetime: string;
  replies: CommentType[];
  likes?: number;
  parentId?: number;
  postId?: number;
  userId?: number;
  userName?: string;
  userAvatar?: string;
  status?: string;
}

export interface PostTag {
  tagId: number;
  tagName: string;
  tagColor?: string;
  postCount: number;
  status?: string;
}

export interface PostFavorite {
  favoriteId: number;
  postId: number;
  userId: number;
  postTitle?: string;
  postCover?: string;
  status: string;
} 