import * as registerApi from '@/api/system/register'

export default {
  namespace: 'register',
  
  state: {
    submitting: false,
    error: null
  },
  
  effects: {
    *submit({ payload }, { call, put }) {
      yield put({
        type: 'changeSubmitting',
        payload: true
      })
      
      try {
        const response = yield call(registerApi.register, payload)
        
        if (response.code === 200) {
          yield put({
            type: 'registerSuccess'
          })
        } else {
          yield put({
            type: 'registerFailure',
            payload: response.msg
          })
        }
      } catch (error) {
        yield put({
          type: 'registerFailure',
          payload: error.response?.data?.msg || '注册失败'
        })
      }
      
      yield put({
        type: 'changeSubmitting',
        payload: false
      })
    }
  },
  
  reducers: {
    changeSubmitting(state, { payload }) {
      return {
        ...state,
        submitting: payload
      }
    },
    registerSuccess(state) {
      return {
        ...state,
        error: null
      }
    },
    registerFailure(state, { payload }) {
      return {
        ...state,
        error: payload
      }
    }
  }
}