import { request } from '@umijs/max';

export interface PlanetEntity {
    planetId?: number;
    name?: string;
    filename?: string;
    description?: string;
    createTime?: string;
}

export interface UserPlanetEntity {
    userId?: number;
    planetId?: number;
    updateTime?: string;
}

export async function getPlanetList(params: {
    pageNum?: number;
    pageSize?: number;
}) {
    const res = await request<{ code: number; data: PlanetEntity[] }>('/api/planets/list', {
        method: 'GET',
        params,
    });
    return res.data;

}

export async function getPlanetInfo(params: { planetId: number | undefined; }): Promise<PlanetEntity> {
    const res = await request<{ code: number; data: PlanetEntity }>(`/api/planets/info/${params.planetId}`, {
        method: 'GET',
    });
    return res.data;
}

export async function uploadPlanetFile(file: File) {
    const formData = new FormData();
    formData.append('file', file);
    return request('/api/planets/upload', {
        method: 'POST',
        data: formData,
        requestType: 'form',
    });
}

export async function getUserPlanet(params: { userId: number }) {
    const res = await request<{ code: number; data: UserPlanetEntity }>('/api/planets/user', {
        method: 'GET',
        params,
    });
    return res.data;
}

export async function updatePlanet(entity: PlanetEntity) {
    return request('/api/planets/update', {
        method: 'POST',
        data: entity,
    });
}
export async function updateUserPlanet(entity: UserPlanetEntity) {
    return request('/api/planets/updateUserPlanet', {
        method: 'POST',
        data: entity,
    });
}

export async function deletePlanet(ids: number[]) {
    return request('/api/planets/delete', {
        method: 'POST',
        data: ids,
    });
}

export async function getRandomUserPlanets() {
    const res = await request<{ code: number; data: UserPlanetEntity[] }>('/api/planets/random', {
        method: 'GET',
    })
    return res.data;
}