package com.example.myproject.controller;

import com.example.myproject.controller.DynamicController;
import com.example.myproject.service.DynamicService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

import static org.mockito.Mockito.*;
import static org.junit.jupiter.api.Assertions.*;

class DynamicControllerTest {

    @InjectMocks
    private DynamicController dynamicController;

    @Mock
    private DynamicService dynamicService;

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks(this);
    }

    // 测试创建动态接口
    @Test
    void testCreateDynamic() {
        Long userId = 1L;
        String content = "This is a test dynamic";
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("dynamicId", 123L);
        mockResponse.put("message", "动态创建成功");

        // 模拟 dynamicService.createDynamic 返回
        when(dynamicService.createDynamic(userId, null, content, null)).thenReturn(mockResponse);

        // 调用控制器方法
        Map<String, Object> responseMap = dynamicController.createDynamic(userId, null, content, null);
        ResponseEntity<Map<String, Object>> responseEntity = ResponseEntity.ok(responseMap);

        // 验证返回的结果
        assertEquals(200, responseEntity.getStatusCodeValue());
        assertEquals("动态创建成功", responseEntity.getBody().get("message"));
        assertEquals(123L, responseEntity.getBody().get("dynamicId"));
    }


    // 测试删除动态接口
    @Test
    void testDeleteDynamic() {
        Long dynamicId = 1L;
        // 模拟 dynamicService.deleteDynamic 方法行为
        doNothing().when(dynamicService).deleteDynamic(dynamicId);

        // 调用控制器方法
        ResponseEntity<String> response = dynamicController.deleteDynamic(dynamicId);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("动态删除成功", response.getBody());
    }

    // 测试添加评论接口
    @Test
    void testAddComment() {
        Long userId = 1L;
        Long dynamicId = 1L;
        Map<String, String> commentContent = new HashMap<>();
        commentContent.put("content", "This is a test comment");

        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("comment_id", 101L);
        mockResponse.put("message", "评论成功");

        // 模拟 dynamicService.addComment 返回
        when(dynamicService.addComment(userId, dynamicId, "This is a test comment")).thenReturn(mockResponse);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> response = dynamicController.addComment(userId, dynamicId, commentContent);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("评论成功", response.getBody().get("message"));
        assertEquals(101L, response.getBody().get("comment_id"));
    }

    // 测试获取用户动态接口
    @Test
    void testGetAllUserDynamics() {
        Long userId = 1L;
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("dynamic", "mock_dynamic_data");

        // 模拟 dynamicService.getAllUserDynamics 返回
        when(dynamicService.getAllUserDynamics(userId)).thenReturn(mockResponse);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> response = dynamicController.getAllUserDynamics(userId);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("success", response.getBody().get("status"));
        assertNotNull(response.getBody().get("dynamic"));
    }

    // 测试获取所有好友动态接口
    @Test
    void testGetAllUserAndFriendsDynamics() {
        Long userId = 1L;
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("dynamic", "mock_friend_dynamic_data");

        // 模拟 dynamicService.getAllUserAndFriendsDynamics 返回
        when(dynamicService.getAllUserAndFriendsDynamics(anyList())).thenReturn(mockResponse);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> response = dynamicController.getAllUserAndFriendsDynamics(userId);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("success", response.getBody().get("status"));
        assertNotNull(response.getBody().get("dynamic"));
    }

    // 测试点赞动态接口
    @Test
    void testLikeDynamic() {
        Map<String, Long> request = new HashMap<>();
        request.put("userId", 1L);
        request.put("dynamicId", 1L);

        // 模拟 dynamicService.likeDynamic 返回
        when(dynamicService.likeDynamic(1L, 1L)).thenReturn(true);

        // 调用控制器方法
        ResponseEntity<String> response = dynamicController.likeDynamic(request);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("Like successful", response.getBody());
    }

    // 测试取消点赞接口
    @Test
    void testUnlikeDynamic() {
        Map<String, Long> request = new HashMap<>();
        request.put("userId", 1L);
        request.put("dynamicId", 1L);

        // 模拟 dynamicService.unlikeDynamic 返回
        when(dynamicService.unlikeDynamic(1L, 1L)).thenReturn(true);

        // 调用控制器方法
        ResponseEntity<String> response = dynamicController.unlikeDynamic(request);

        // 验证返回的结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("Unlike successful", response.getBody());
    }
}
