package com.example.myproject.controller;

import com.example.myproject.controller.LevelController;
import com.example.myproject.service.LevelService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

import static org.mockito.Mockito.*;
import static org.junit.jupiter.api.Assertions.*;

class LevelControllerTest {

    @InjectMocks
    private LevelController levelController;

    @Mock
    private LevelService levelService;

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks(this);
    }

    // 测试获取用户经验接口
    @Test
    void testGetExperience() {
        Long userId = 1L;
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("current_experience", 1500);
        mockResponse.put("level", "Intermediate");
        mockResponse.put("next_level_experience", 2000);

        // 模拟 levelService.getUserExperience 返回
        when(levelService.getUserExperience(userId)).thenReturn(mockResponse);

        // 调用控制器方法
        Map<String, Object> response = levelController.getExperience(userId);

        // 验证返回的结果
        assertEquals(1500, response.get("current_experience"));
        assertEquals("Intermediate", response.get("level"));
        assertEquals(2000, response.get("next_level_experience"));
    }

    // 测试更新用户经验接口
    @Test
    void testUpdateExperience() {
        Long userId = 1L;
        Integer experience = 500;
        String source = "Quest";
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("message", "经验更新成功");
        mockResponse.put("current_experience", 2000);

        Map<String, Object> params = new HashMap<>();
        params.put("user_id", userId);
        params.put("experience", experience);
        params.put("source", source);

        // 模拟 levelService.updateExperience 返回
        when(levelService.updateExperience(userId, experience, source)).thenReturn(mockResponse);

        // 调用控制器方法
        Map<String, Object> response = levelController.updateExperience(params);

        // 验证返回的结果
        assertEquals("success", response.get("status"));
        assertEquals("经验更新成功", response.get("message"));
        assertEquals(2000, response.get("current_experience"));
    }

    // 测试检查用户升级条件接口
    @Test
    void testCheckUpgrade() {
        Long userId = 1L;
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("can_upgrade", true);
        mockResponse.put("next_level_experience", 2000);
        mockResponse.put("current_experience", 1500);

        // 模拟 levelService.checkUpgrade 返回
        when(levelService.checkUpgrade(userId)).thenReturn(mockResponse);

        // 调用控制器方法
        Map<String, Object> response = levelController.checkUpgrade(userId);

        // 验证返回的结果
        assertTrue((Boolean) response.get("can_upgrade"));
        assertEquals(2000, response.get("next_level_experience"));
        assertEquals(1500, response.get("current_experience"));
    }

    // 测试升级用户等级接口
    @Test
    void testUpgradeUserLevel() {
        Long userId = 1L;
        Boolean canUpgrade = true;
        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("message", "升级成功");
        mockResponse.put("new_level", "Advanced");

        Map<String, Object> request = new HashMap<>();
        request.put("user_id", userId);
        request.put("can_upgrade", canUpgrade);

        // 模拟 levelService.upgradeUserLevel 返回
        when(levelService.upgradeUserLevel(userId, canUpgrade)).thenReturn(mockResponse);

        // 调用控制器方法
        Map<String, Object> response = levelController.upgradeUserLevel(request);

        // 验证返回的结果
        assertEquals("success", response.get("status"));
        assertEquals("升级成功", response.get("message"));
        assertEquals("Advanced", response.get("new_level"));
    }
}
