package com.example.myproject.controller;

import com.example.myproject.controller.UserFollowController;
import com.example.myproject.service.UserFollowService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;
import java.util.List;

import java.util.Map;

import static org.mockito.Mockito.*;
import static org.junit.jupiter.api.Assertions.*;

class UserFollowControllerTest {

    @InjectMocks
    private UserFollowController userFollowController;

    @Mock
    private UserFollowService userFollowService;

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks(this);
    }

    // 测试用户关注接口
    @Test
    void testFollow() {
        Long followerId = 1L;
        Long followedId = 2L;
        Map<String, Object> mockResponse = Map.of(
                "status", "success",
                "message", "关注成功"
        );

        // 模拟 userFollowService.follow() 返回
        when(userFollowService.follow(followerId, followedId)).thenReturn(mockResponse);

        // 创建请求体
        Map<String, Long> request = Map.of("follower_id", followerId);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> responseEntity = userFollowController.follow(followedId, request);

        // 验证返回的状态码和内容
        assertEquals(200, responseEntity.getStatusCodeValue());
        assertEquals("success", responseEntity.getBody().get("status"));
        assertEquals("关注成功", responseEntity.getBody().get("message"));
    }

    // 测试取消关注接口
    @Test
    void testUnfollow() {
        Long followerId = 1L;
        Long followedId = 2L;
        Map<String, Object> mockResponse = Map.of(
                "status", "success",
                "message", "取消关注成功"
        );

        // 模拟 userFollowService.unfollow() 返回
        when(userFollowService.unfollow(followerId, followedId)).thenReturn(mockResponse);

        // 创建请求体
        Map<String, Long> request = Map.of("follower_id", followerId);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> responseEntity = userFollowController.unfollow(followedId, request);

        // 验证返回的状态码和内容
        assertEquals(200, responseEntity.getStatusCodeValue());
        assertEquals("success", responseEntity.getBody().get("status"));
        assertEquals("取消关注成功", responseEntity.getBody().get("message"));
    }

    // 测试获取某个用户的粉丝列表接口
    @Test
    void testGetFollowers() {
        Long userId = 1L;
        Map<String, Object> mockResponse = Map.of(
                "status", "success",
                "total", 2,
                "followers", List.of(
                        Map.of("user_id", 2L, "username", "user2", "avatar_url", "url2"),
                        Map.of("user_id", 3L, "username", "user3", "avatar_url", "url3")
                )
        );

        // 模拟 userFollowService.getFollowers() 返回
        when(userFollowService.getFollowers(userId)).thenReturn(mockResponse);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> responseEntity = userFollowController.getFollowers(userId);

        // 验证返回的状态码和内容
        assertEquals(200, responseEntity.getStatusCodeValue());
        assertEquals("success", responseEntity.getBody().get("status"));
        assertEquals(2, responseEntity.getBody().get("total"));
        assertEquals(2, ((List<?>) responseEntity.getBody().get("followers")).size());
    }

    // 测试获取某个用户的关注列表接口
    @Test
    void testGetFollowing() {
        Long userId = 1L;
        Map<String, Object> mockResponse = Map.of(
                "status", "success",
                "total", 2,
                "following", List.of(
                        Map.of("user_id", 2L, "username", "user2", "avatar_url", "url2"),
                        Map.of("user_id", 3L, "username", "user3", "avatar_url", "url3")
                )
        );

        // 模拟 userFollowService.getFollowing() 返回
        when(userFollowService.getFollowing(userId)).thenReturn(mockResponse);

        // 调用控制器方法
        ResponseEntity<Map<String, Object>> responseEntity = userFollowController.getFollowing(userId);

        // 验证返回的状态码和内容
        assertEquals(200, responseEntity.getStatusCodeValue());
        assertEquals("success", responseEntity.getBody().get("status"));
        assertEquals(2, responseEntity.getBody().get("total"));
        assertEquals(2, ((List<?>) responseEntity.getBody().get("following")).size());
    }
}
