package com.example.myproject.controller;

import com.example.myproject.service.UserMessageService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.when;

class UserMessageControllerTest {

    @InjectMocks
    private UserMessageController userMessageController;

    @Mock
    private UserMessageService userMessageService;

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void testSendMessage() {
        // 准备测试数据
        Map<String, Object> params = new HashMap<>();
        params.put("sender_id", 1L);
        params.put("receiver_id", 2L);
        params.put("content", "测试消息");

        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("message", "私信发送成功");
        mockResponse.put("message_id", 100L);

        // 模拟Service方法调用
        when(userMessageService.sendMessage(1L, 2L, "测试消息")).thenReturn(mockResponse);

        // 执行测试
        ResponseEntity<Map<String, Object>> response = userMessageController.sendMessage(params);

        // 验证结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("success", response.getBody().get("status"));
        assertEquals("私信发送成功", response.getBody().get("message"));
        assertEquals(100L, response.getBody().get("message_id"));
    }

    @Test
    void testGetUserMessages() {
        // 准备测试数据
        Long userId = 1L;

        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("messages", new HashMap<>());

        // 模拟Service方法调用
        when(userMessageService.getUserMessages(userId)).thenReturn(mockResponse);

        // 执行测试
        ResponseEntity<Map<String, Object>> response = userMessageController.getUserMessages(userId);

        // 验证结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("success", response.getBody().get("status"));
    }

    @Test
    void testGetMessage() {
        // 准备测试数据
        Long messageId = 1L;

        Map<String, Object> mockResponse = new HashMap<>();
        mockResponse.put("status", "success");
        mockResponse.put("message", new HashMap<>());

        // 模拟Service方法调用
        when(userMessageService.getMessage(messageId)).thenReturn(mockResponse);

        // 执行测试
        ResponseEntity<Map<String, Object>> response = userMessageController.getMessage(messageId);

        // 验证结果
        assertEquals(200, response.getStatusCodeValue());
        assertEquals("success", response.getBody().get("status"));
    }
}