package com.example.myproject.common.exception;

import com.example.myproject.common.CommonResultStatus;
import com.example.myproject.common.ResultStatus;

public class RocketPTException extends RuntimeException {
    private final ResultStatus status;

    public RocketPTException(ResultStatus status) {
        super(status.getMessage());
        this.status = status;
    }

    public RocketPTException(ResultStatus status, String message) {
        super(message);
        this.status = status;
    }

    public RocketPTException(String message) {
        super(message);
        this.status = CommonResultStatus.FAIL;
    }

    public ResultStatus getStatus() {
        return status;
    }


}
