package com.example.myproject.dto;

import lombok.Data;
import javax.validation.constraints.*;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class PromotionCreateDTO {
    @NotBlank(message = "促销名称不能为空")
    @Size(max = 100, message = "促销名称长度不能超过100个字符")
    private String name;
    
    @Size(max = 500, message = "描述长度不能超过500个字符")
    private String description;
    
    @NotNull(message = "开始时间不能为空")
    private LocalDateTime startTime;
    
    @NotNull(message = "结束时间不能为空")
    private LocalDateTime endTime;
    
    @NotNull(message = "折扣比例不能为空")
    @Min(value = 0, message = "折扣比例不能小于0")
    @Max(value = 100, message = "折扣比例不能大于100")
    private double discountPercentage;
    
    @NotEmpty(message = "适用种子列表不能为空")
    private List<Long> applicableTorrentIds;
    
    @AssertTrue(message = "结束时间必须晚于开始时间")
    public boolean isEndTimeAfterStartTime() {
        return endTime != null && startTime != null && endTime.isAfter(startTime);
    }
} 