package com.example.myproject.dto;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

@Data
public class TorrentUpdateDTO {
    @NotBlank(message = "标题不能为空")
    @Size(max = 30, message = "名称长度不能超过30个字符")
    private String title;
    
    @Size(max = 1000, message = "描述长度不能超过1000个字符")
    private String description;
    
    @NotBlank(message = "分类不能为空")
    private String category;
    

    private String tags;
    @NotBlank(message = "封面不能为空")
    
    private String imageUrl;
} 