package com.example.myproject.dto.param;

import com.example.myproject.common.base.OrderPageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 种子查询参数
 */
@Data
@Schema(description = "种子查询参数")
public class TorrentParam extends OrderPageParam {

    @Schema(description = "关键字")
    private String keyword;

    @Schema(description = "分类")
    private String category;

    @Schema(description = "促销种子")
    private String free;

    private Set<String> likeExpressions;

    public void buildLike() {
        likeExpressions = new LinkedHashSet<>();
        if (StringUtils.isEmpty(keyword)) {
            return;
        }
        keyword = keyword.replace(".", " ");
        String[] searchstrExploded = keyword.split(" ");
        for (int i = 0; i < searchstrExploded.length && i < 10; i++) {
            String searchstrElement = searchstrExploded[i].trim();
            if (!searchstrElement.isEmpty()) {
                likeExpressions.add(searchstrElement);
            }
        }
    }
}