package com.example.myproject.dto.vo;

import java.time.LocalDateTime;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
public class TorrentVO {
    /**
     * 种子ID
     */
    @Schema(description = "种子ID")
    private Long id;

    /**
     * 标题
     */
    @NotEmpty
    @Schema(description = "标题")
    private String title;


    /**
     * 封面
     */
    @Schema(description = "封面")
    private String imageUrl;
    /**
     * 描述
     */
    @NotEmpty
    @Schema(description = "描述")
    private String description;

    /**
     * 类别
     */
    @NotNull
    @Schema(description = "类别")
    private String category;


    /**
     * 添加日期
     */
    @Schema(description = "添加日期")
    private LocalDateTime createTime;

    /**
     * 修改日期
     */
    @Schema(description = "修改日期")
    private LocalDateTime updateTime;

    /**
     * 上传者
     */
    @Schema(description = "上传者")
    private String uploader;
    /**
     * 文件大小
     */
    @Schema(description = "文件大小")
    private Long size;
   


    /**
     * 评论数
     */
    @Schema(description = "评论数")
    private Integer comments;
    /**
     * 浏览次数
     */
    @Schema(description = "浏览次数")
    private Integer views;
    /**
     * 点击次数
     */
    @Schema(description = "点击次数")
    private Integer hits;


    /**
     * 下载数
     */
    @Schema(description = "下载数")
    private Integer leechers;
    /**
     * 做种数
     */
    @Schema(description = "做种数")
    private Integer seeders;

    /**
     * 完成次数
     */
    @Schema(description = "完成次数")
    private Integer completions;

}
