package com.example.myproject.entity;



import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.util.Objects;

import lombok.Getter;
import lombok.Setter;

/**
 * Base class for an entity, as explained in the book "Domain Driven Design".
 * All entities in this project have an identity attribute with type Long and
 * name id. Inspired by the DDD Sample project.

 */
@Setter
@Getter
public abstract class EntityBase {

    /**
     * This identity field has the wrapper class type Long so that an entity which
     * has not been saved is recognizable by a null identity.
     */
    @TableId(type = IdType.AUTO)
    private Integer id;

    @Override
    public boolean equals(final Object object) {
        if (!(object instanceof EntityBase)) {
            return false;
        }
        if (!getClass().equals(object.getClass())) {
            return false;
        }
        final EntityBase that = (EntityBase) object;
        _checkIdentity(this);
        _checkIdentity(that);
        return this.id.equals(that.getId());
    }


    private void _checkIdentity(final EntityBase entity) {
        if (entity.getId() == null) {
            throw new IllegalStateException("Comparison identity missing in entity: " + entity);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + getId() + ">";
    }

}
