package com.example.myproject.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@TableName("favorite")
@ApiModel("收藏实体类")
public class FavoriteEntity {
    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "收藏ID", example = "1")
    private Long id;

    @ApiModelProperty(value = "用户ID", example = "1001")
    @JsonProperty("userId")
    @TableField("user_id")
    private Long userId;

    @ApiModelProperty(value = "种子ID", example = "2001")
    @JsonProperty("seedId")
    @TableField("seed_id")
    private Long seedId;

    @ApiModelProperty(value = "收藏时间", example = "2024-05-13 12:00:00")
    @JsonProperty("createTime")
    @TableField("create_time")
    private Date createTime;
}