package com.example.myproject.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("torrent")
@ApiModel("种子实体类")
public class TorrentEntity {

    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "种子ID", example = "1")
    private Long id;

    @JsonProperty("infoHash")
    @ApiModelProperty(value = "种子信息哈希", example = "abcdef123456")
    private String infoHash;

    @JsonProperty("fileName")
    @ApiModelProperty(value = "种子文件名", example = "movie_torrent_file.torrent")
    private String fileName;

    @JsonProperty("uploader")
    @ApiModelProperty(value = "上传者", example = "user123")
    private String uploader;

    @JsonProperty("createdTime")
    @ApiModelProperty(value = "上传时间", example = "2024-01-01 12:00:00")
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime createTime;

    @JsonProperty("updateTime")
    @ApiModelProperty(value = "更新时间", example = "2024-01-01 12:00:00")

    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updateTime;

    @JsonProperty("size")
    @ApiModelProperty(value = "种子文件大小", example = "123456")
    private Long size;

    @JsonProperty("title")
    @ApiModelProperty(value = "种子标题", example = "《星际穿越》")
    private String title;

    @JsonProperty("description")
    @ApiModelProperty(value = "种子描述", example = "这是一部好看的科幻电影")
    private String description;

    @JsonProperty("tags")
    @ApiModelProperty(value = "种子标签", example = "[\"科幻\",\"动作\"]")
    private String tags;

    @JsonProperty("category")
    @ApiModelProperty(value = "种子分类", example = "movie")
    private String category;

    @JsonProperty("imageUrl")
    @ApiModelProperty(value = "种子封面图URL", example = "http://example.com/images/cover.jpg")
    private String imageUrl;

    @JsonProperty("leechers")
    @ApiModelProperty(value = "下载次数", example = "123")
    private Integer leechers;

    @JsonProperty("seeders")
    @ApiModelProperty(value = "做种数", example = "10")
    private Integer seeders;

    @JsonProperty("comments")
    @ApiModelProperty(value = "评论数", example = "5")
    private Integer comments;

    @JsonProperty("views")
    @ApiModelProperty(value = "浏览次数", example = "1000")
    private Integer views;

    @JsonProperty("hits")
    @ApiModelProperty(value = "点击次数", example = "2000")
    private Integer hits;

    @JsonProperty("promotionTimeType")
    @ApiModelProperty(value = "促销时间类型", example = "1")
    private Integer promotionTimeType;

    @JsonProperty("promotionUntil")
    @ApiModelProperty(value = "促销截止日期", example = "2024-12-31T23:59:59")
    private LocalDateTime promotionUntil;

    
    @JsonProperty("torrentFile")
    @ApiModelProperty(value = "种子文件", example = "base64 encoded torrent file")
    private byte[] torrentFile;

    @JsonProperty("isDeleted")
    @ApiModelProperty(value = "是否删除", example = "false")
    private Boolean isDeleted;

    public TorrentEntity() {
    }
}