package com.example.myproject.entity;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

@Data
@TableName("user") // 指定数据库表名
@ApiModel("用户实体类") // 用于描述模型
public class User {

    @TableId(type = IdType.AUTO) // 指定主键策略
    @ApiModelProperty(value = "用户ID", example = "1")
    private Long id;

    @JsonProperty("username")
    @ApiModelProperty(value = "用户名", example = "22301115")
    private String username;

    @JsonProperty("nickname")
    @ApiModelProperty(value = "昵称", example = "cyl")
    private String nickname;

    @JsonProperty("role")
    @ApiModelProperty(value = "角色", example = "Student")
    private String role;

    @JsonProperty("password")
    @ApiModelProperty(value = "密码", example = "123")
    private String password;

    @JsonProperty("status")
    @ApiModelProperty(value = "用户状态", example = "1")
    private int status;

    @JsonProperty("email")
    @ApiModelProperty(value = "电子邮件地址", example = "john_doe@example.com")
    private String email;

    @JsonProperty("email_verified")
    @ApiModelProperty(value = "邮箱验证状态", example = "true")
    private boolean emailVerified;

    @JsonProperty("avatar")
    @ApiModelProperty(value = "头像")
    private String avatar;

    @JsonProperty("uploaded")
    @ApiModelProperty(value = "上传量", example = "1000")
    private Long uploaded;

    @JsonProperty("downloaded")
    @ApiModelProperty(value = "下载量", example = "500")
    private Long downloaded;

    @JsonProperty("create_time")
    @ApiModelProperty(value = "创建时间", example = "2024-04-01T12:00:00")
    private LocalDateTime createTime;

    @JsonProperty("update_time")
    @ApiModelProperty(value = "更新时间", example = "2024-04-01T12:00:00")
    private LocalDateTime updateTime;

    @JsonProperty("is_deleted")
    @ApiModelProperty(value = "是否删除", example = "false")
    private Boolean isDeleted;

    public User() {
    }
}
