package com.example.myproject.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.AllArgsConstructor;

import java.time.Instant;

@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("verification_token")
@ApiModel("验证令牌实体类")
public class VerificationToken {

    @TableId(type = IdType.AUTO)
    @ApiModelProperty(value = "令牌ID")
    private Long id;

    @ApiModelProperty(value = "令牌字符串")
    @TableField("token")
    private String token;

    @ApiModelProperty(value = "令牌过期日期")
    @TableField("expiry_date")
    private Instant expiryDate;

    @ApiModelProperty(value = "用户名")
    @TableField("username")
    private String username;

    @ApiModelProperty(value = "电子邮件地址")
    @TableField("email")
    private String email;

    @ApiModelProperty(value = "加密后的密码")
    @TableField("password")
    private String password;

    public VerificationToken(String token, String username, String email, String password, Instant expiryDate) {
        this.token = token;
        this.username = username;
        this.email = email;
        this.password = password;
        this.expiryDate = expiryDate;
    }

    /**
     * 检查令牌是否过期
     * @return true 如果令牌已过期
     */
    public boolean isExpired() {
        return expiryDate.isBefore(Instant.now());
    }
}
