package com.example.myproject.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.myproject.entity.FavoriteEntity;
import org.apache.ibatis.annotations.*;

@Mapper
public interface FavoriteMapper extends BaseMapper<FavoriteEntity> {

   @Select("SELECT * FROM favorite WHERE user_id = #{userId} AND seed_id = #{seedId} LIMIT 1")
    FavoriteEntity selectByUserIdAndSeedId(@Param("userId") Long userId, @Param("seedId") Long seedId);

    @Delete("DELETE FROM favorite WHERE user_id = #{userId} AND seed_id = #{seedId}")
    void deleteByUserIdAndSeedId(@Param("userId") Long userId, @Param("seedId") Long seedId);
}