package com.example.myproject.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.myproject.entity.Promotion;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.time.LocalDateTime;
import java.util.List;

@Mapper
public interface PromotionMapper extends BaseMapper<Promotion> {

    @Select("SELECT * FROM promotion WHERE is_deleted = false " +
            "AND start_time <= #{now} AND end_time >= #{now}")
    List<Promotion> findActivePromotions(@Param("now") LocalDateTime now);

    /**
     * 查找某个torrentId是否在促销活动的applicable_torrent_ids字符串中
     * 用MySQL的FIND_IN_SET判断
     */
    @Select("SELECT p.* FROM promotion p " +
            "WHERE p.is_deleted = false " +
            "AND p.start_time <= #{now} AND p.end_time >= #{now} " +
            "AND FIND_IN_SET(#{torrentId}, p.applicable_torrent_ids) > 0")
    List<Promotion> findActivePromotionsForTorrent(
            @Param("torrentId") Long torrentId,
            @Param("now") LocalDateTime now);

    /**
     * 校验种子id是否存在，返回计数，0代表不存在，>0代表存在
     */
    @Select("SELECT COUNT(*) FROM torrent WHERE id = #{torrentId}")
    int checkTorrentExists(@Param("torrentId") Long torrentId);

    /**
     * 插入促销活动
     */
//    int insert(Promotion promotion);

    /**
     * 根据ID更新促销活动（例如软删除）
     */
    int updateById(Promotion promotion);

    /**
     * 根据ID查询促销活动
     */
    Promotion selectById(@Param("id") Long id);
}
