package com.example.myproject.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.example.myproject.dto.param.TorrentParam;
import com.example.myproject.entity.TorrentEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

@Mapper
public interface TorrentMapper extends BaseMapper<TorrentEntity> {

    @Select("SELECT * FROM torrents WHERE info_hash = #{infoHash}")
    TorrentEntity selectByInfoHash(String infoHash);
    
    @Select("SELECT * FROM torrents WHERE seed_id = #{seedId}")
    TorrentEntity selectBySeedId(Long seedId);
    
    List<TorrentEntity> search(@Param("param") TorrentParam param);
    
    @Update("UPDATE torrent SET downloads = downloads + 1 WHERE id = #{torrentId}")
    void increaseDownloads(@Param("torrentId") Long torrentId);
    
    boolean checkFavorite(@Param("seedId") Long seedId, @Param("userId") Long userId);
    
    void addFavorite(@Param("seedId") Long seedId, @Param("userId") Long userId);
    
    void removeFavorite(@Param("seedId") Long seedId, @Param("userId") Long userId);
}