package com.example.myproject.mapper;
import com.example.myproject.entity.User;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.data.repository.query.Param;

import java.util.List;

@Mapper
public interface UserMapper extends BaseMapper<User> {


    User selectByUsername(@Param("username") String username);

    User selectByUsernameAndPassword(@Param("username") String username, @Param("password") String password);

    User selectByEmail(@Param("email") String email);


    // 根据用户名包含查找用户
    List<User> selectByUsernameContaining(@Param("name") String name);

    @Update("UPDATE user SET downloaded = downloaded + #{size} WHERE id = #{userId}")
    void increaseDownloaded(@Param("userId") Long userId, @Param("size") double size);
    
    boolean hasRole(@Param("userId") Long userId, @Param("role") String role);

}