package com.example.myproject.service;

import com.example.myproject.common.base.Result;
import com.example.myproject.entity.TorrentEntity;
import com.example.myproject.dto.param.TorrentParam;
import com.example.myproject.dto.param.TorrentUploadParam;
import com.example.myproject.dto.TorrentUpdateDTO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

public interface TorrentService {
    List<TorrentEntity> search(TorrentParam param);
    
    TorrentEntity selectBySeedId(Long seedId);
    
    void uploadTorrent(MultipartFile file, TorrentUploadParam param) throws IOException;
    
    byte[] fetch(Long seedId, String passkey) throws IOException;
    
    Result favorite(Long seedId, Long userId);
    
    void deleteTorrent(Long seedId);
    
    void updateTorrent(Long seedId, TorrentUpdateDTO updateDTO);
    
    boolean canUserDeleteTorrent(Long seedId, Long userId);
    
    boolean canUserUpdateTorrent(Long seedId, Long userId);
    
    boolean checkUserUploadRatio(Long userId);
    
    double calculateDownloadSize(Long torrentId, Long userId);
    
    void recordDownload(Long torrentId, Long userId, double downloadSize);
}
