package com.example.myproject.service.serviceImpl;

import com.example.myproject.mapper.UserMapper;
import com.example.myproject.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserDetailsServiceImpl implements UserDetailsService {

    @Autowired
    private UserMapper userMapper;

    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        //username参数,是在登陆时,用户传递的表单数据username
        //主要读取数据库3个值 username password authorities
        User user= userMapper.selectByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("用户名未找到");
        }

        String authorityName = user.getRole();
        //为了返回一个UserDetails 使用User
        List<GrantedAuthority> authorities = new ArrayList<>();
        GrantedAuthority authority = new SimpleGrantedAuthority(authorityName);
        authorities.add(authority);
        return new org.springframework.security.core.userdetails.User(
                user.getUsername(),
                user.getPassword(),
                true, // accountEnabled
                true, // accountNonExpired
                true, // credentialsNonExpired
                true, // accountNonLocked
                AuthorityUtils.createAuthorityList("ROLE_USER") // 设置用户的角色或权限
        );
    }
}