import React from 'react';
import { render, screen, fireEvent } from '@testing-library/react';
import AuthPage from './AuthPage';

describe('AuthPage component', () => {
  test('switches between login and register forms', () => {
    render(<AuthPage />);

    const registerButton = screen.getByText('点击注册');
    fireEvent.click(registerButton);

    const usernameInput = screen.getByPlaceholderText('请输入用户名');
    const passwordInput = screen.getByPlaceholderText('请输入密码');
    const emailInput = screen.getByPlaceholderText('请输入邮箱');

    expect(usernameInput).toBeInTheDocument();
    expect(passwordInput).toBeInTheDocument();
    expect(emailInput).toBeInTheDocument();

    const loginButton = screen.getByText('点击登录');
    fireEvent.click(loginButton);

    const loginUsernameInput = screen.getByPlaceholderText('请输入用户名');
    const loginPasswordInput = screen.getByPlaceholderText('请输入密码');
    const loginSubmitButton = screen.getByText('登录');

    expect(loginUsernameInput).toBeInTheDocument();
    expect(loginPasswordInput).toBeInTheDocument();
    expect(loginSubmitButton).toBeInTheDocument();
  });
});