import React, { useState, useEffect } from'react';
import axios from 'axios';

const PostDetail = ({ post_id }) => {
  const [post, setPost] = useState({});

  useEffect(() => {
    const fetchPost = async () => {
      try {
        const response = await axios.get(`/echo/forum/posts/${post_id}`);
        setPost(response.data);
      } catch (error) {
        console.error('Error fetching post detail:', error);
      }
    };
    fetchPost();
  }, [post_id]);

  return (
    <div>
      <h1>{post.title}</h1>
      <p>作者: {post.author}</p>
      <p>内容: {post.Postcontent}</p>
      {post.imgUrl && <img src={post.imgUrl} alt={post.title} />}
    </div>
  );
};

export default PostDetail;