import React, { useState, useEffect } from 'react';
import { useRoute } from 'wouter';
import axios from 'axios';
import './PostDetailPage.css';

const API_BASE = process.env.REACT_APP_API_BASE;

const PostDetailPage = () => {
  const [post, setPost] = useState(null);
  const [loading, setLoading] = useState(true);
  const [errorMsg, setErrorMsg] = useState('');
  
  // 使用 wouter 的 useRoute 获取 postId 参数
  const { params } = useRoute('/forum/post/:postId');
  const postId = params?.postId;

  useEffect(() => {
    const fetchPostDetail = async () => {
      setLoading(true);
      setErrorMsg('');
      try {
        const response = await axios.get(`${API_BASE}/echo/forum/posts/${postId}`);
        setPost(response.data);
      } catch (error) {
        console.error('获取帖子详情失败:', error);
        setErrorMsg('加载失败，请稍后重试');
      } finally {
        setLoading(false);
      }
    };

    if (postId) {
      fetchPostDetail();
    }
  }, [postId]);

  if (loading) return <p>加载中...</p>;
  if (errorMsg) return <p className="error-text">{errorMsg}</p>;
  if (!post) return <p>没有找到该帖子。</p>;

  return (
    <div className="post-detail-page">
      <h2>{post.title}</h2>
      <div className="post-meta">
        <span>作者：{post.userProfile.nickname}</span>
        <span>发布时间：{new Date(post.created_at).toLocaleString()}</span>
      </div>
      <div className="post-content">
        <p>{post.content}</p>
      </div>
      {post.cover_image_url && (
        <div className="post-image">
          <img src={post.cover_image_url} alt="封面" />
        </div>
      )}
    </div>
  );
};

export default PostDetailPage;
