// export default Recommend;
import React, { useEffect, useState } from 'react';
import './Recommend.css';

const Recommend = () => {
  const [paidLists, setPaidLists] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const fetchPaidLists = async () => {
      try {
        const API_BASE = process.env.REACT_APP_API_BASE;
        const response = await fetch(`${API_BASE}/echo/recommendations/paid?user_id=1`);
        console.log('请求地址:', `${process.env.REACT_APP_API_BASE}/echo/recommendations/paid?user_id=1`);


        // const response = await fetch('/echo/recommendations/paid?user_id=1');
        const data = await response.json();
        if (data.status === 'success') {
          setPaidLists(data.paid_recommendations);
        } else {
          console.warn('获取付费片单失败');
        }
      } catch (error) {
        console.error('请求出错:', error);
      } finally {
        setLoading(false);
      }
    };

    fetchPaidLists();
  }, []);

  return (
    <div className="recommend-wrapper">
      <h2 className="recommend-section-title">付费片单</h2>
      {loading ? (
        <p>加载中...</p>
      ) : (
        <div className="recommend-paid-row">
          {paidLists.map((item) => (
            <div className="paid-card" key={item.group_id}>
              <img src={item.image_url} alt={item.group_name} className="paid-cover" />
              <div className="paid-title">{item.group_name}</div>
            </div>
          ))}
        </div>
      )}
    </div>
  );
};

export default Recommend;
