import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { useParams } from 'react-router-dom';
import Header from '../../../components/Header';
import './SeedDetail.css';

const API_BASE = process.env.REACT_APP_API_BASE;

const SeedDetail = () => {
  const { seed_id } = useParams();
  const [seed, setSeed] = useState(null);
  const [error, setError] = useState(null);

  useEffect(() => {
    axios
      .get(`${API_BASE}/echo/seeds/${seed_id}`)
      .then((res) => {
        if (res.data.status === 'success') {
          setSeed(res.data.seed);
        } else {
          setError('未能获取种子信息');
        }
      })
      .catch(() => {
        setError('获取种子详情失败');
      });
  }, [seed_id]);

  if (error) {
    return (
      <div>
        <Header />
        <div className="seed-detail-container">
          <p className="error">{error}</p>
        </div>
      </div>
    );
  }

  if (!seed) {
    return (
      <div>
        <Header />
        <div className="seed-detail-container">
          <p>加载中...</p>
        </div>
      </div>
    );
  }

  return (
    <div>
      <Header />
      <div className="seed-detail-container">
        <div className="seed-header">
          <img src={seed.cover_url} alt={seed.title} className="cover-image" />
          <div className="seed-basic-info">
            <h1>{seed.title}</h1>
            <p><strong>分类：</strong>{seed.category}</p>
            <p><strong>标签：</strong>{seed.tags.join(' / ')}</p>
            <p><strong>简介：</strong>{seed.description}</p>
            <p><strong>大小：</strong>{seed.size} GB</p>
            <p><strong>分辨率：</strong>{seed.resolution}</p>
            <p><strong>片长：</strong>{seed.duration}</p>
            <p><strong>地区：</strong>{seed.region}</p>
            <p><strong>发布时间：</strong>{new Date(seed.upload_time).toLocaleString()}</p>
            <p><strong>下载次数：</strong>{seed.downloads}</p>
          </div>
        </div>

        {(seed.category === '电影' || seed.category === '电视剧') && (
          <div className="seed-media-info">
            <p><strong>导演：</strong>{seed.director}</p>
            <p><strong>编剧：</strong>{seed.writer}</p>
            <p><strong>主演：</strong>{seed.actors.join(' / ')}</p>
          </div>
        )}

        <div className="uploader-info">
          <h3>发种人</h3>
          <img src={seed.user.avatar_url} alt={seed.user.username} className="avatar" />
          <p>{seed.user.username}</p>
        </div>
      </div>
    </div>
  );
};

export default SeedDetail;
