import React, { useEffect, useState } from 'react';
import Header from '../../components/Header';
import { useGroupStore } from '../../context/useGroupStore';
import GroupList from './GroupList';
import GroupPagination from './GroupPagination';
import './InterestGroup.css';
import axios from 'axios';

const InterestGroup = () => {
  const { fetchGroupList } = useGroupStore();

  const [showModal, setShowModal] = useState(false);
  const [groupName, setGroupName] = useState('');
  const [groupDescription, setGroupDescription] = useState('');

  useEffect(() => {
    fetchGroupList();
  }, [fetchGroupList]);

  const handleCreateGroup = async () => {
    try {
      // ✅ 修改请求体字段名，使用驼峰命名法
      const res = await axios.post('http://localhost:3011/echo/groups/createGroup', {
        userId: 1,                 // 改为驼峰命名 userId
        groupName: groupName,      // 改为驼峰命名 groupName
        description: groupDescription,
        // 移除time字段，使用后端生成的时间
        memberCount: 1,            // 添加初始成员数
        category: '默认分类',
        coverImage: 'https://picsum.photos/300/200',  // 改为驼峰命名 coverImage
      });

      if (res.status === 200 && res.data.status === 'success') {
        alert('小组创建成功');
        setShowModal(false);
        setGroupName('');
        setGroupDescription('');
        fetchGroupList(); // 刷新列表
      } else {
        // 显示后端返回的详细错误信息
        alert('创建失败: ' + res.data.message);
      }
    } catch (error) {
      // 处理网络错误或其他异常
      alert('创建失败，请检查网络连接或输入内容');
      console.error('创建小组错误:', error);
    }
  };

  return (
    <div className="interest-group-container">
      <Header />
      <div className="interest-group-card">
        <button className="create-group-btn" onClick={() => setShowModal(true)}>
          创建小组
        </button>

        {showModal && (
          <div className="modal-overlay">
            <div className="modal-content">
              <h2>创建新小组</h2>
              <input
                type="text"
                placeholder="小组名称"
                value={groupName}
                onChange={(e) => setGroupName(e.target.value)}
              />
              <textarea
                placeholder="小组简介"
                value={groupDescription}
                onChange={(e) => setGroupDescription(e.target.value)}
              />
              <div className="modal-buttons">
                <button onClick={handleCreateGroup}>确定</button>
                <button onClick={() => setShowModal(false)}>取消</button>
              </div>
            </div>
          </div>
        )}

        <GroupList />
        <GroupPagination />
      </div>
    </div>
  );
};

export default InterestGroup;