// import React, { useEffect, useState, useRef } from 'react';
// import './Promotion.css';

// const Promotion = () => {
//   const [promotions, setPromotions] = useState([]);
//   const [coldResources, setColdResources] = useState([]);
//   const [loading, setLoading] = useState(true);

//   const [promoIndex, setPromoIndex] = useState(0);
//   const [coldIndex, setColdIndex] = useState(0);

//   const promoTimerRef = useRef(null);
//   const coldTimerRef = useRef(null);

//   useEffect(() => {
//     fetchData();
//   }, []);

//   useEffect(() => {
//     if (promotions.length === 0) return;
//     clearInterval(promoTimerRef.current);
//     promoTimerRef.current = setInterval(() => {
//       setPromoIndex(prev => (prev + 1) % promotions.length);
//     }, 5000);
//     return () => clearInterval(promoTimerRef.current);
//   }, [promotions]);

//   useEffect(() => {
//     if (coldResources.length === 0) return;
//     clearInterval(coldTimerRef.current);
//     coldTimerRef.current = setInterval(() => {
//       setColdIndex(prev => (prev + 1) % coldResources.length);
//     }, 5000);
//     return () => clearInterval(coldTimerRef.current);
//   }, [coldResources]);

//   const fetchData = async () => {
//     try {
//       // ✅ 获取促销活动列表（新接口）
//       const promoResponse = await fetch(`seeds/promotions`);
//       const promoJson = await promoResponse.json();
//       const promoData = Array.isArray(promoJson?.result) ? promoJson.result : [];
//       setPromotions(promoData);

//       // 冷门资源（接口保持不变，若已更换请提供文档）
//       const coldResponse = await fetch(`/echo/resources/cold`);
//       const coldData = await coldResponse.json();
//       setColdResources(coldData);
//     } catch (error) {
//       console.error('获取数据失败:', error);
//     } finally {
//       setLoading(false);
//     }
//   };

//   if (loading) {
//     return <div className="promotion-container">加载中...</div>;
//   }

//   const prevPromo = () => setPromoIndex((promoIndex - 1 + promotions.length) % promotions.length);
//   const nextPromo = () => setPromoIndex((promoIndex + 1) % promotions.length);
//   const prevCold = () => setColdIndex((coldIndex - 1 + coldResources.length) % coldResources.length);
//   const nextCold = () => setColdIndex((coldIndex + 1) % coldResources.length);

//   const currentPromo = promotions[promoIndex];
//   const currentCold = coldResources[coldIndex];

//   return (
//     <div className="promotion-container carousel-container">
//       {/* 促销活动轮播 */}
//       <section className="carousel-section">
//         <h2>当前促销活动</h2>
//         {promotions.length === 0 || !currentPromo ? (
//           <div className="empty-state">暂无促销活动</div>
//         ) : (
//           <div
//             className="carousel"
//             onMouseEnter={() => clearInterval(promoTimerRef.current)}
//             onMouseLeave={() => {
//               promoTimerRef.current = setInterval(() => {
//                 setPromoIndex(prev => (prev + 1) % promotions.length);
//               }, 3000);
//             }}
//           >
//             <button className="arrow left" onClick={prevPromo}>&lt;</button>
//             <div className="slide">
//               <div><strong>促销名称：</strong>{currentPromo?.name ?? '未知'}</div>
//               <div><strong>促销时间：</strong>
//                 {currentPromo?.pStartTime && currentPromo?.pEndTime
//                   ? `${new Date(currentPromo.pStartTime).toLocaleString()} ～ ${new Date(currentPromo.pEndTime).toLocaleString()}`
//                   : '未知'}
//               </div>
//               <div><strong>上传奖励系数：</strong>{currentPromo?.uploadCoeff ?? '无'}</div>
//               <div><strong>下载折扣系数：</strong>{currentPromo?.downloadCoeff ?? '无'}</div>
//               {currentPromo?.description && (
//                 <div><strong>描述：</strong>{currentPromo.description}</div>
//               )}
//             </div>
//             <button className="arrow right" onClick={nextPromo}>&gt;</button>
//           </div>
//         )}
//       </section>

//       {/* 冷门资源轮播 */}
//       <section className="carousel-section">
//         <h2>冷门资源推荐</h2>
//         {coldResources.length === 0 || !currentCold ? (
//           <div className="empty-state">暂无冷门资源推荐</div>
//         ) : (
//           <div
//             className="carousel"
//             onMouseEnter={() => clearInterval(coldTimerRef.current)}
//             onMouseLeave={() => {
//               coldTimerRef.current = setInterval(() => {
//                 setColdIndex(prev => (prev + 1) % coldResources.length);
//               }, 3000);
//             }}
//           >
//             <button className="arrow left" onClick={prevCold}>&lt;</button>
//             <div className="slide cold-slide">
//               <img src={currentCold.poster} alt={currentCold.title} className="resource-poster" />
//               <div className="resource-info">
//                 <div><strong>标题：</strong>{currentCold.title}</div>
//                 <div><strong>下载量：</strong>{currentCold.download_count ?? 0} | <strong>种子数：</strong>{currentCold.seed_count ?? 0}</div>
//                 <div><strong>激励：</strong>
//                   {currentCold.incentives?.download_exempt && <span className="incentive-badge">免下载量</span>}
//                   {currentCold.incentives?.extra_seed_bonus && <span className="incentive-badge">做种加成</span>}
//                   {!currentCold.incentives?.download_exempt && !currentCold.incentives?.extra_seed_bonus && '无'}
//                 </div>
//               </div>
//             </div>
//             <button className="arrow right" onClick={nextCold}>&gt;</button>
//           </div>
//         )}
//       </section>
//     </div>
//   );
// };

// export default Promotion;

import React, { useEffect, useState, useRef } from 'react';
import './Promotion.css';

const Promotion = () => {
  const [promotions, setPromotions] = useState([]);
  const [loading, setLoading] = useState(true);

  const [promoIndex, setPromoIndex] = useState(0);
  const promoTimerRef = useRef(null);

  useEffect(() => {
    fetchData();
  }, []);

  useEffect(() => {
    if (promotions.length === 0) return;
    clearInterval(promoTimerRef.current);
    promoTimerRef.current = setInterval(() => {
      setPromoIndex(prev => (prev + 1) % promotions.length);
    }, 5000);
    return () => clearInterval(promoTimerRef.current);
  }, [promotions]);

  const fetchData = async () => {
    try {
      // ✅ 获取促销活动列表（新接口）
      const promoResponse = await fetch(`/seeds/promotions`);
      const promoJson = await promoResponse.json();
      console.log('接口返回数据:', promoJson);
      const promoData = Array.isArray(promoJson?.result) ? promoJson.result : [];
      setPromotions(promoData);
    } catch (error) {
      console.error('获取促销活动失败:', error);
    } finally {
      setLoading(false);
    }
  };

  if (loading) {
    return <div className="promotion-container">加载中...</div>;
  }

  const prevPromo = () => setPromoIndex((promoIndex - 1 + promotions.length) % promotions.length);
  const nextPromo = () => setPromoIndex((promoIndex + 1) % promotions.length);
  const currentPromo = promotions[promoIndex];

  return (
    <div className="promotion-container carousel-container">
      {/* 促销活动轮播 */}
      <section className="carousel-section">
        <h2>当前促销活动</h2>
        {promotions.length === 0 || !currentPromo ? (
          <div className="empty-state">暂无促销活动</div>
        ) : (
          <div
            className="carousel"
            onMouseEnter={() => clearInterval(promoTimerRef.current)}
            onMouseLeave={() => {
              promoTimerRef.current = setInterval(() => {
                setPromoIndex(prev => (prev + 1) % promotions.length);
              }, 3000);
            }}
          >
            <button className="arrow left" onClick={prevPromo}>&lt;</button>
            <div className="slide">
              <div><strong>促销名称：</strong>{currentPromo?.name ?? '未知'}</div>
              <div><strong>促销时间：</strong>
                {currentPromo?.pStartTime && currentPromo?.pEndTime
                  ? `${new Date(currentPromo.pStartTime).toLocaleString()} ～ ${new Date(currentPromo.pEndTime).toLocaleString()}`
                  : '未知'}
              </div>
              <div><strong>上传奖励系数：</strong>{currentPromo?.uploadCoeff ?? '无'}</div>
              <div><strong>下载折扣系数：</strong>{currentPromo?.downloadCoeff ?? '无'}</div>
              {currentPromo?.description && (
                <div><strong>描述：</strong>{currentPromo.description}</div>
              )}
            </div>
            <button className="arrow right" onClick={nextPromo}>&gt;</button>
          </div>
        )}
      </section>
    </div>
  );
};

export default Promotion;

