import React from 'react';
import GroupItem from './GroupItem';
import { useGroupStore } from '../../context/useGroupStore';

const GroupList = () => {
  const { groups, loading, error } = useGroupStore();

  if (loading) return <p>加载中...</p>;
  if (error) return <p className="error">{error}</p>;
  if (!groups || groups.length === 0) return (
    <div className="empty-state">
      <p>没有找到匹配的兴趣小组</p>
      <p>请尝试调整筛选条件或搜索关键词</p>
    </div>
  );

  return (
    <div className="group-list">
      {groups.map(group => (
        <GroupItem key={group.group_id} group={group} />
      ))}
    </div>
  );
};

export default GroupList;