import React, { useRef, useState } from 'react';
import axios from 'axios';

const SimpleUploader = () => {
  const fileInputRef = useRef(null);
  const [message, setMessage] = useState('');

  const handleUpload = async () => {
    const file = fileInputRef.current?.files[0];
    console.log('[handleUpload] file:', file);

    if (!file) {
      setMessage('请先选择文件');
      return;
    }

    const formData = new FormData();
    formData.append('file', file);

    try {
      const response = await axios.post('/seeds/upload', formData, {
        headers: { 'Content-Type': 'multipart/form-data' },
      });

      console.log('[handleUpload] response:', response);
      setMessage(response.data?.msg || '上传成功');
    } catch (err) {
      console.error('[handleUpload] 上传失败:', err);
      setMessage('上传失败');
    }
  };

  return (
    <div style={{ padding: '2rem' }}>
      <h2>种子上传测试</h2>
      <input type="file" accept=".torrent" ref={fileInputRef} />
      <button onClick={handleUpload} style={{ marginLeft: '1rem' }}>
        上传
      </button>
      <div style={{ marginTop: '1rem' }}>{message}</div>
    </div>
  );
};

export default SimpleUploader;
