import React, { useState } from 'react';
import UserNav from './UserNav.jsx'; // 显式添加.jsx扩展名
import UserProfile from './UserProfile.jsx';
import NewbieTasks from './NewbieTasks.jsx';
import Header from '../../components/Header.jsx'; // 假设Header也是JSX组件
import './UserProfile.css';

const UserCenterPage = () => {
  const [activeTab, setActiveTab] = useState('profile');

  const renderContent = () => {
    switch (activeTab) {
      case 'profile':
        return <UserProfile />;
      case 'newbieTasks':
        return <NewbieTasks />;
      default:
        return null;
    }
  };

  return (
    <div className="user-profile-container">
      <Header />
      <div className="user-center" style={{ display: 'flex' }}>
        <UserNav activeKey={activeTab} onSelect={setActiveTab} />
        <div className="common-card right-content" style={{ flex: 1, marginLeft: 20 }}>
          {renderContent()}
        </div>
      </div>
    </div>
  );
};

export default UserCenterPage;