import React from 'react';
import { Link, useLocation } from 'react-router-dom';
import './UserNav.css'; // 导入 UserNav 样式文件

const UserNav = () => {
  const location = useLocation();

  // 竖直导航栏的链接项（已添加“新手考核”）
  const navLinks = [
    { to: '/user/profile', label: '个人资料' },
    { to: '/user/dynamics', label: '我的动态' },
    { to: '/user/friends', label: '我的好友' },
    { to: '/user/groups', label: '我的群组' },
    { to: '/user/collections', label: '我的收藏' },
    { to: '/user/newbie-tasks', label: '新手考核' },
    { to: '/user/invite', label: '邀请新用户' },
  ];

  // 判断路径是否是当前活动页面
  const isActive = (path) => location.pathname.startsWith(path);

  return (
    <div className="user-nav-container">
      <nav className="user-nav">
        {navLinks.map(({ to, label }) => (
          <Link
            key={to}
            to={to}
            className={`user-nav-item ${isActive(to) ? 'active' : ''}`}
          >
            {label}
          </Link>
        ))}
      </nav>
    </div>
  );
};

export default UserNav;
