// import axios from 'axios';

// // 获取所有小组
// export const fetchGroups = async (params) => {
//   const response = await axios.post('/echo/groups/getAllGroups', params);
//   return response.data;
// };

// // 加入小组
// export const joinGroup = async (groupId, userId) => {
//   const response = await axios.post(`/echo/groups/${groupId}/join`, { user_id: userId });
//   return response.data;
// };

// // 创建帖子
// export const createPost = async (groupId, userId, content, title, images) => {
//   const formData = new FormData();
//   formData.append('user_id', userId);
//   formData.append('content', content);
//   formData.append('title', title);
  
//   if (images && images.length > 0) {
//     for (let i = 0; i < images.length; i++) {
//       formData.append('images', images[i]);
//     }
//   }

//   const response = await axios.post(`/echo/groups/${groupId}/createPost`, formData, {
//     headers: { 'Content-Type': 'multipart/form-data' }
//   });
  
//   return response.data;
// };

import axios from 'axios';

// 获取所有小组
export const fetchGroups = async (params) => {
  try {
    const response = await axios.post('/echo/groups/getAllGroups', params);
    return response.data;
  } catch (error) {
    console.error('获取小组列表失败:', error.response?.data || error.message);
    return { status: 'failure', message: '获取小组失败' };
  }
};

// 加入小组
export const joinGroup = async (groupId, userId) => {
  try {
    const response = await axios.post(
      `/echo/groups/${groupId}/join`,
      { user_id: userId },
      {
        headers: {
          'Content-Type': 'application/json'  // ✅ 明确设置为 JSON
        }
      }
    );
    return response.data;
  } catch (error) {
    console.error('加入小组失败:', error.response?.data || error.message);
    return { status: 'failure', message: '加入小组失败' };
  }
};


// 创建帖子
export const createPost = async (groupId, userId, content, title, images) => {
  try {
    const formData = new FormData();
    formData.append('user_id', userId);
    formData.append('content', content);
    formData.append('title', title);

    if (images && images.length > 0) {
      for (let i = 0; i < images.length; i++) {
        formData.append('images', images[i]);
      }
    }

    const response = await axios.post(`/echo/groups/${groupId}/createPost`, formData, {
      headers: { 'Content-Type': 'multipart/form-data' }
    });

    return response.data;
  } catch (error) {
    console.error('创建帖子失败:', error.response?.data || error.message);
    return { status: 'failure', message: '创建帖子失败' };
  }
};
