import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { useParams } from 'react-router-dom';
import Header from '../../../components/Header';
import './SeedDetail.css';



const SeedDetail = () => {
    const { seed_id } = useParams();
    const [seed, setSeed] = useState(null);
    const [error, setError] = useState(null);
    const [comments, setComments] = useState([]);
    const [newComment, setNewComment] = useState('');

    useEffect(() => {
        axios
           .get(`/echo/seeds/${seed_id}`)
           .then((res) => {
                if (res.data.status === 'success') {
                    setSeed(res.data.seed);
                } else {
                    setError('未能获取种子信息');
                }
            })
           .catch(() => {
                setError('获取种子详情失败');
            });

        // 模拟获取评论数据，实际需要调用 API
        axios.get(`/echo/seeds/${seed_id}/comments`)
           .then((res) => {
                if (res.data.status === 'success') {
                    setComments(res.data.comments);
                }
            })
           .catch(() => {
                console.log('获取评论失败');
            });
    }, [seed_id]);

    const handleDownload = async () => {
        if (seed) {
            const peer_id = 'echo-' + Math.random().toString(36).substring(2, 10);
            const ip = '127.0.0.1';
            const port = 6881;
            const uploaded = 0;
            const downloaded = 0;
            const left = 0;

            try {
                const response = await axios.get(`/echo/seeds/${seed.seed_id}/download`, {
                    params: { peer_id, ip, port, uploaded, downloaded, left },
                    responseType: 'blob'
                });

                const blob = new Blob([response.data], { type: 'application/x-bittorrent' });
                const downloadUrl = URL.createObjectURL(blob);
                const a = document.createElement('a');
                a.href = downloadUrl;
                a.download = `${seed.seed_id}.torrent`;
                a.click();
                URL.revokeObjectURL(downloadUrl);
            } catch (error) {
                console.error('下载失败:', error);
                alert('下载失败，请稍后再试。');
            }
        }
    };

    const handleCollect = () => {
        // 这里可以添加收藏逻辑，调用相应 API
        alert('已收藏');
    };

    const handleAddComment = () => {
        if (newComment.trim()) {
            // 这里可以添加评论逻辑，调用相应 API
            setComments([...comments, { content: newComment, user: '用户' }]);
            setNewComment('');
        }
    };

    if (error) {
        return (
            <div className="seed-detail-page">
                <Header />
                <div className="seed-detail">
                    <p className="error-text">{error}</p>
                </div>
            </div>
        );
    }

    if (!seed) {
        return (
            <div className="seed-detail-page">
                <Header />
                <div className="seed-detail">
                    <p>加载中...</p>
                </div>
            </div>
        );
    }

    return (
        <div className="seed-detail-page">
            <Header />
            <div className="seed-detail">
                <h1>{seed.title}</h1>
                <div className="seed-header-container">
                    <div className="seed-info">
                        <div className="seed-basic-info">
                            <p><strong>分类：</strong>{seed.category}</p>
                            <p><strong>发布时间：</strong>{new Date(seed.upload_time).toLocaleString()}</p>
                            <p><strong>标签：</strong>{seed.tags.join(' / ')}</p>
                            <p><strong>简介：</strong>{seed.description}</p>
                            <p><strong>大小：</strong>{seed.size} GB</p>
                            <p><strong>分辨率：</strong>{seed.resolution}</p>
                            <p><strong>片长：</strong>{seed.duration}</p>
                            <p><strong>地区：</strong>{seed.region}</p>
                            <p><strong>下载次数：</strong>{seed.downloads}</p>
                        </div>
                        {(seed.category === '电影' || seed.category === '电视剧') && (
                            <div className="seed-media-info">
                                <p><strong>导演：</strong>{seed.director}</p>
                                <p><strong>编剧：</strong>{seed.writer}</p>
                                <p><strong>主演：</strong>{seed.actors.join(' / ')}</p>
                            </div>
                        )}
                    </div>
                    <img src={seed.cover_url} alt={seed.title} className="cover-image" />
                </div>
                <div className="action-buttons">
                    <button className="btn" onClick={handleDownload}>下载</button>
                    <button className="btn" onClick={handleCollect}>收藏</button>             
                </div>
                <hr className="divider" />
                {/* 评论部分 */}
                <h3>评论区</h3>
                <div className="comments-section">
                    <div className="comments-list">
                        {comments.map((comment, index) => (
                            <div key={index} className="comment">
                                <p className="comment-user">{comment.user}</p>
                                <p className="comment-content">{comment.content}</p>
                            </div>
                        ))}
                    </div>
                    <div className="add-comment-form">
                        <textarea
                            placeholder="输入你的评论..."
                            value={newComment}
                            onChange={(e) => setNewComment(e.target.value)}
                        />
                        <div className="comment-options">
                        <button className="btn" onClick={handleAddComment}>发布评论</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
};

export default SeedDetail;
    