import React, { createContext, useContext, useState, useEffect } from 'react';

export const UserContext = createContext();

export const UserProvider = ({ children }) => {
  const [user, setUser] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const storedUser = localStorage.getItem('user');
    if (storedUser) {
      setUser(JSON.parse(storedUser));
    } else {
      // 设置默认用户
      const defaultUser = { userId: 1, username: '测试用户' };
      localStorage.setItem('user', JSON.stringify(defaultUser));
      setUser(defaultUser);
    }
    setLoading(false);
  }, []);

  const saveUser = (userData) => {
    if (userData && userData.id) {
      localStorage.setItem('user', JSON.stringify(userData));
      setUser(userData);
    } else {
      console.error('无效的用户数据:', userData);
    }
  };

  const logout = () => {
    localStorage.removeItem('user');
    setUser(null);
  };

  return (
    <UserContext.Provider value={{ user, saveUser, logout, loading }}>
      {children}
    </UserContext.Provider>
  );
};

export const useUser = () => {
  const context = useContext(UserContext);
  if (!context) {
    throw new Error('useUser must be used within a UserProvider');
  }
  return context;
};